/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.utils.AssertUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringFormat {
    private static final Pattern GROUP_SIZE_PATTERN = Pattern.compile("\\{\\d+}");
    private Group[] groups;
    private String format;
    private int inputLength;
    private int outputLength;

    public StringFormat(String format) throws IllegalArgumentException {
        AssertUtils.assertNotNull(format, "format is required.");
        this.parseFormat(format);
    }

    private void parseFormat(String format) {
        Matcher matcher = GROUP_SIZE_PATTERN.matcher(format);
        ArrayList<Group> list = new ArrayList<Group>();
        int inputLength = 0;
        int outputLength = 0;
        int lastEnd = 0;
        while (matcher.find()) {
            String text;
            int start = matcher.start();
            if (start > 0 && !(text = format.substring(lastEnd, start)).isEmpty()) {
                list.add(new Group(text, 0));
                outputLength += text.length();
            }
            String sizeGroup = matcher.group();
            int size = Integer.parseInt(sizeGroup.substring(1, sizeGroup.length() - 1));
            inputLength += size;
            outputLength += size;
            list.add(new Group(null, size));
            lastEnd = matcher.end();
        }
        this.groups = list.toArray(new Group[list.size()]);
        this.format = format;
        this.inputLength = inputLength;
        this.outputLength = outputLength;
    }

    public int getInputLength() {
        return this.inputLength;
    }

    public String format(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() != this.inputLength) {
            throw new IllegalArgumentException("str is invalid length (str=" + str + ", format=" + this.format + ")");
        }
        StringBuilder sb = new StringBuilder(this.outputLength);
        int pos = 0;
        for (Group group : this.groups) {
            if (group.length > 0) {
                sb.append(str.substring(pos, group.length + pos));
                pos += group.length;
                continue;
            }
            sb.append(group.text);
        }
        return sb.toString();
    }

    private static class Group {
        final String text;
        final int length;

        public Group(String text, int length) {
            this.text = text;
            this.length = length;
        }
    }
}

