/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.ConfigBase;
import com.appslandia.common.base.StringWriter;
import com.appslandia.common.utils.CharsetUtils;
import com.appslandia.common.utils.DateUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertyConfig
extends ConfigBase {
    private static final long serialVersionUID = 1L;

    public PropertyConfig() {
        super(new LinkedHashMap<String, String>());
    }

    public PropertyConfig(Map<String, String> newMap) {
        super(newMap);
    }

    public void load(InputStream is) throws IOException {
        LinkedProperties props = new LinkedProperties();
        props.load(is);
        this.fromProperties(props);
    }

    public void load(Reader r) throws IOException {
        LinkedProperties props = new LinkedProperties();
        props.load(r);
        this.fromProperties(props);
    }

    public void load(File file) throws IOException {
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CharsetUtils.UTF_8));
            this.load(br);
        }
    }

    public void load(String file) throws IOException {
        this.load(new File(file));
    }

    protected void fromProperties(Properties props) {
        for (Object k : props.keySet()) {
            String key = (String)k;
            String value = (String)props.get(key);
            if (key.isEmpty()) continue;
            this.configs.put(key, !value.isEmpty() ? value : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file, String comments) throws IOException {
        try (BufferedWriter bw = null;){
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), CharsetUtils.UTF_8));
            this.store(bw, comments);
        }
    }

    public void store(String file, String comments) throws IOException {
        this.store(new File(file), comments);
    }

    public void store(OutputStream os, String comments) throws IOException {
        this.toProperties().store(os, comments);
    }

    public void store(Writer w, String comments) throws IOException {
        this.toProperties().store(w, comments);
    }

    protected Properties toProperties() {
        LinkedProperties props = new LinkedProperties();
        for (Map.Entry config : this.configs.entrySet()) {
            ((Properties)props).put(config.getKey(), config.getValue() != null ? config.getValue() : "");
        }
        return props;
    }

    public String toString() {
        try {
            StringWriter out = new StringWriter();
            this.store(out, this.getClass().getName());
            return out.toString();
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public void put(String key, boolean value) {
        this.configs.put(key, Boolean.toString(value));
    }

    @Override
    public void put(String key, int value) {
        this.configs.put(key, Integer.toString(value));
    }

    @Override
    public void put(String key, long value) {
        this.configs.put(key, Long.toString(value));
    }

    @Override
    public void put(String key, float value) {
        this.configs.put(key, Float.toString(value));
    }

    @Override
    public void put(String key, double value) {
        this.configs.put(key, Double.toString(value));
    }

    @Override
    public void put(String key, Boolean value) {
        this.configs.put(key, value != null ? value.toString() : null);
    }

    @Override
    public void put(String key, Integer value) {
        this.configs.put(key, value != null ? value.toString() : null);
    }

    @Override
    public void put(String key, Long value) {
        this.configs.put(key, value != null ? value.toString() : null);
    }

    @Override
    public void put(String key, Float value) {
        this.configs.put(key, value != null ? value.toString() : null);
    }

    @Override
    public void put(String key, Double value) {
        this.configs.put(key, value != null ? value.toString() : null);
    }

    @Override
    public void put(String key, Date value) {
        this.configs.put(key, value != null ? DateUtils.iso8601Date(value) : null);
    }

    @Override
    public void put(String key, Time value) {
        this.configs.put(key, value != null ? DateUtils.iso8601Time(value) : null);
    }

    @Override
    public void put(String key, Timestamp value) {
        this.configs.put(key, value != null ? DateUtils.iso8601DateTime(value) : null);
    }

    private static class LinkedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        final Set<Object> keys = new LinkedHashSet<Object>();

        private LinkedProperties() {
        }

        @Override
        public Set<Object> keySet() {
            return this.keys;
        }

        @Override
        public Enumeration<Object> keys() {
            return Collections.enumeration(this.keys);
        }

        @Override
        public Object put(Object key, Object value) {
            this.keys.add(key);
            return super.put(key, value);
        }
    }
}

