/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.utils.CharsetUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MemoryStream
extends OutputStream {
    final ChunkList chunks;
    final int blockSize;
    private int count;
    private int nextIndex;

    public MemoryStream() {
        this(128);
    }

    public MemoryStream(int blockSize) {
        this.blockSize = blockSize;
        this.chunks = new ChunkList(new byte[this.blockSize]);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = this.chunks.last.buf;
        int lenLeft = buf.length - this.nextIndex;
        if (lenLeft >= 1) {
            buf[this.nextIndex] = (byte)b;
            ++this.nextIndex;
        } else {
            this.chunks.insert(new byte[this.blockSize]);
            this.chunks.last.buf[0] = (byte)b;
            this.nextIndex = 1;
        }
        ++this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] lb = this.chunks.last.buf;
        int lenLeft = lb.length - this.nextIndex;
        if (lenLeft >= len) {
            System.arraycopy(b, off, lb, this.nextIndex, len);
            this.nextIndex += len;
        } else {
            int moreLen = len - lenLeft;
            int moreBlocks = moreLen / this.blockSize;
            if (moreBlocks * this.blockSize < moreLen) {
                ++moreBlocks;
            }
            this.chunks.insert(new byte[moreBlocks * this.blockSize]);
            if (lenLeft == 0) {
                System.arraycopy(b, off, this.chunks.last.buf, 0, len);
                this.nextIndex = len;
            } else {
                System.arraycopy(b, off, lb, this.nextIndex, lenLeft);
                System.arraycopy(b, off + lenLeft, this.chunks.last.buf, 0, len - lenLeft);
                this.nextIndex = len - lenLeft;
            }
        }
        this.count += len;
    }

    public void writeTo(OutputStream out) throws IOException {
        Chunk c = this.chunks.first;
        while (c != null) {
            if (c != this.chunks.last) {
                out.write(c.buf, 0, c.buf.length);
            } else {
                out.write(c.buf, 0, this.nextIndex);
            }
            c = c.next;
        }
    }

    public byte[] toByteArray() {
        byte[] array = new byte[this.size()];
        int destPos = 0;
        Chunk c = this.chunks.first;
        while (c != null) {
            if (c != this.chunks.last) {
                System.arraycopy(c.buf, 0, array, destPos, c.buf.length);
                destPos += c.buf.length;
            } else {
                System.arraycopy(c.buf, 0, array, destPos, this.nextIndex);
                destPos += this.nextIndex;
            }
            c = c.next;
        }
        return array;
    }

    public byte[] digest(String algorithm) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        Chunk c = this.chunks.first;
        while (c != null) {
            if (c != this.chunks.last) {
                md.update(c.buf, 0, c.buf.length);
            } else {
                md.update(c.buf, 0, this.nextIndex);
            }
            c = c.next;
        }
        return md.digest();
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public void reset() {
        this.chunks.first.next = null;
        this.chunks.last = this.chunks.first;
        this.count = 0;
        this.nextIndex = 0;
    }

    public String toString(Charset charset) {
        return new String(this.toByteArray(), 0, this.count, charset);
    }

    public String toString(String charset) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), 0, this.count, charset);
    }

    public String toString() {
        return new String(this.toByteArray(), 0, this.count, CharsetUtils.UTF_8);
    }

    private static class Chunk {
        final byte[] buf;
        Chunk next;

        public Chunk(byte[] buf) {
            this.buf = buf;
        }
    }

    private static class ChunkList {
        final Chunk first;
        Chunk last;

        public ChunkList(byte[] buf) {
            this.last = this.first = new Chunk(buf);
        }

        public void insert(byte[] buf) {
            Chunk c;
            this.last.next = c = new Chunk(buf);
            this.last = c;
        }
    }
}

