/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.BoolFormatException;
import com.appslandia.common.base.Config;
import com.appslandia.common.base.DateFormatException;
import com.appslandia.common.utils.DateUtils;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.StringFormatUtils;
import com.appslandia.common.utils.StringUtils;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public abstract class ConfigBase
implements Config,
Map<String, String>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<String, String> configs;

    public ConfigBase(Map<String, String> newMap) {
        this.configs = newMap;
    }

    @Override
    public String getString(String key) {
        return this.get(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        String value = this.get(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public String getRequiredString(String key) throws NullPointerException {
        String value = this.get(key);
        if (value == null) {
            throw new NullPointerException("Property is required (key=" + key + ")");
        }
        return value;
    }

    @Override
    public String getFormatted(String key) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        Map props = (Map)ObjectUtils.cast(this);
        return StringFormatUtils.format(value, props);
    }

    @Override
    public String getRequiredFormatted(String key) throws NullPointerException {
        String value = this.get(key);
        if (value == null) {
            throw new NullPointerException("Property is required (key=" + key + ")");
        }
        Map props = (Map)ObjectUtils.cast(this);
        return StringFormatUtils.format(value, props);
    }

    @Override
    public String getFormatted(String key, Map<String, Object> parameters) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        return StringFormatUtils.format(value, parameters);
    }

    @Override
    public String getRequiredFormatted(String key, Map<String, Object> parameters) throws NullPointerException {
        String value = this.get(key);
        if (value == null) {
            throw new NullPointerException("Property is required (key=" + key + ")");
        }
        return StringFormatUtils.format(value, parameters);
    }

    @Override
    public String getFormatted(String key, Object ... parameters) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        return StringFormatUtils.format(value, parameters);
    }

    @Override
    public String getRequiredFormatted(String key, Object ... parameters) throws NullPointerException {
        String value = this.get(key);
        if (value == null) {
            throw new NullPointerException("Property is required (key=" + key + ")");
        }
        return StringFormatUtils.format(value, parameters);
    }

    @Override
    public boolean getBool(String key, boolean defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return true;
        }
        if (value.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return false;
        }
        return defaultValue;
    }

    @Override
    public boolean getRequiredBool(String key) throws NullPointerException, BoolFormatException {
        String value = this.get(key);
        if (value == null) {
            throw new NullPointerException("Property is required (key=" + key + ")");
        }
        if (value.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return true;
        }
        if (value.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return false;
        }
        throw new BoolFormatException(value);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public int getRequiredInt(String key) throws NullPointerException, NumberFormatException {
        String value = this.get(key);
        if (value == null) {
            throw new NullPointerException("Property is required (key=" + key + ")");
        }
        return Integer.parseInt(value);
    }

    @Override
    public long getLong(String key, long defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public long getRequiredLong(String key) throws NullPointerException, NumberFormatException {
        String value = this.get(key);
        if (value == null) {
            throw new NullPointerException("Property is required (key=" + key + ")");
        }
        return Long.parseLong(value);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public float getRequiredFloat(String key) throws NullPointerException, NumberFormatException {
        String value = this.get(key);
        if (value == null) {
            throw new NullPointerException("Property is required (key=" + key + ")");
        }
        return Float.parseFloat(value);
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public double getRequiredDouble(String key) throws NullPointerException, NumberFormatException {
        String value = this.get(key);
        if (value == null) {
            throw new NullPointerException("Property is required (key=" + key + ")");
        }
        return Double.parseDouble(value);
    }

    @Override
    public Date getDate(String key) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        try {
            return DateUtils.iso8601Date(value);
        }
        catch (DateFormatException ex) {
            return null;
        }
    }

    @Override
    public Date getRequiredDate(String key) throws NullPointerException, DateFormatException {
        String value = this.get(key);
        if (value == null) {
            throw new NullPointerException("Property is required (key=" + key + ")");
        }
        return DateUtils.iso8601Date(value);
    }

    @Override
    public Time getTime(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        try {
            return DateUtils.iso8601Time(value);
        }
        catch (DateFormatException ex) {
            return null;
        }
    }

    @Override
    public Time getRequiredTime(String key) throws NullPointerException, DateFormatException {
        String value = this.get(key);
        if (value == null) {
            throw new NullPointerException("Property is required (key=" + key + ")");
        }
        return DateUtils.iso8601Time(value);
    }

    @Override
    public Timestamp getDateTime(String key) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        try {
            return DateUtils.iso8601DateTime(value);
        }
        catch (DateFormatException ex) {
            return null;
        }
    }

    @Override
    public Timestamp getRequiredDateTime(String key) throws NullPointerException, DateFormatException {
        String value = this.get(key);
        if (value == null) {
            throw new NullPointerException("Property is required (key=" + key + ")");
        }
        return DateUtils.iso8601DateTime(value);
    }

    @Override
    public String get(Object key) {
        return this.configs.get(key);
    }

    @Override
    public Set<String> keySet() {
        return this.configs.keySet();
    }

    @Override
    public int size() {
        return this.configs.size();
    }

    @Override
    public boolean isEmpty() {
        return this.configs.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.configs.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String put(String key, String value) {
        return this.configs.put(key, StringUtils.trimToNull(value));
    }

    @Override
    public String remove(Object key) {
        return this.configs.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.configs.clear();
    }

    @Override
    public Collection<String> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.configs.entrySet();
    }
}

