/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.validators;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={UserNameValidator.class})
@Documented
public @interface UserName {
    public String message() default "{com.appslandia.common.validators.UserName.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class UserNameValidator
    implements ConstraintValidator<UserName, CharSequence> {
        private static final String USERNAME_PATTERN = "[a-z](?!.*\\.\\.)[a-z.\\d]{5,19}";
        final Pattern pattern = Pattern.compile("[a-z](?!.*\\.\\.)[a-z.\\d]{5,19}", 2);

        public void initialize(UserName annotation) {
        }

        public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            Matcher matcher = this.pattern.matcher(value);
            return matcher.matches();
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public UserName[] value();
    }
}

