/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils2;

import java.io.File;
import java.util.LinkedList;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.WebContainer;

public class ShrinkwrapUtils {
    public static void addPackages(ClassContainer<?> archive, String packageBase, String ... packageNames) {
        for (String packageName : packageNames) {
            archive.addPackage(packageBase + "." + packageName);
        }
    }

    public static void addWebInf(WebContainer<?> archive, String webInfDir) {
        ShrinkwrapUtils.addWebInf(archive, new File(webInfDir));
    }

    public static void addWebInf(WebContainer<?> archive, File webInfDir) {
        if (!webInfDir.exists()) {
            throw new IllegalArgumentException("webInfDir is required.");
        }
        if (!webInfDir.getName().endsWith("WEB-INF")) {
            throw new IllegalArgumentException("webInfDir is invalid.");
        }
        LinkedList<File> q = new LinkedList<File>();
        q.add(webInfDir);
        while (!q.isEmpty()) {
            File file = (File)q.remove();
            if (file.isFile()) {
                String target = ShrinkwrapUtils.toUnixPath(webInfDir.toPath().relativize(file.toPath()).toFile().getPath());
                archive.addAsWebInfResource(file, target);
                continue;
            }
            if (!file.isDirectory()) continue;
            for (File subFile : file.listFiles()) {
                q.add(subFile);
            }
        }
    }

    public static void addMetaInf(WebContainer<?> archive, String metaInfDir) {
        ShrinkwrapUtils.addMetaInf(archive, new File(metaInfDir));
    }

    public static void addMetaInf(WebContainer<?> archive, File metaInfDir) {
        if (!metaInfDir.exists()) {
            throw new IllegalArgumentException("metaInfDir is required.");
        }
        if (!metaInfDir.getName().endsWith("META-INF")) {
            throw new IllegalArgumentException("metaInfDir is invalid.");
        }
        LinkedList<File> q = new LinkedList<File>();
        q.add(metaInfDir);
        while (!q.isEmpty()) {
            File file = (File)q.remove();
            if (file.isFile()) {
                String target = ShrinkwrapUtils.toUnixPath(metaInfDir.toPath().getParent().relativize(file.toPath()).toFile().getPath());
                archive.addAsWebInfResource(file, "classes/" + target);
                continue;
            }
            if (!file.isDirectory()) continue;
            for (File subFile : file.listFiles()) {
                q.add(subFile);
            }
        }
    }

    public static void addStaticResources(WebContainer<?> archive, String resourcesDir) {
        ShrinkwrapUtils.addStaticResources(archive, new File(resourcesDir));
    }

    public static void addStaticResources(WebContainer<?> archive, File resourcesDir) {
        if (!resourcesDir.exists()) {
            throw new IllegalArgumentException("resourcesDir is required.");
        }
        LinkedList<File> q = new LinkedList<File>();
        q.add(resourcesDir);
        while (!q.isEmpty()) {
            File file = (File)q.remove();
            if (file.isFile()) {
                if (file.getName().endsWith(".class")) continue;
                String target = ShrinkwrapUtils.toUnixPath(resourcesDir.toPath().relativize(file.toPath()).toFile().getPath());
                archive.addAsWebResource(file, target);
                continue;
            }
            if (!file.isDirectory() || file.getName().equals("WEB-INF") || file.getName().equals("META-INF")) continue;
            for (File subFile : file.listFiles()) {
                q.add(subFile);
            }
        }
    }

    static String toUnixPath(String resourcePath) {
        if (File.separatorChar == '/') {
            return resourcePath;
        }
        return resourcePath.replace('\\', '/');
    }
}

