/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils2;

import com.appslandia.common.base.ToStringBuilder;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ReflectionException;
import com.appslandia.common.utils.ReflectionUtils;
import com.appslandia.common.utils.StringUtils;
import com.appslandia.common.utils.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;

public class PojoBuilder {
    protected String className;
    protected Set<PojoField> fields = new LinkedHashSet<PojoField>();
    protected ClassPool classPool = ClassPool.getDefault();

    public PojoBuilder setClassName(String className) {
        this.className = className;
        return this;
    }

    public PojoBuilder setClassPool(ClassPool classPool) {
        this.classPool = classPool;
        return this;
    }

    public PojoBuilder addField(String name, Class<?> type) {
        return this.addField(name, type, null);
    }

    public PojoBuilder addField(String name, Class<?> type, String initialValue) {
        boolean added = this.fields.add(new PojoField(name, type, false, initialValue));
        AssertUtils.assertTrue(added, "name is duplicated.");
        return this;
    }

    public PojoBuilder addKey(String name, Class<?> type) {
        boolean added = this.fields.add(new PojoField(name, type, true, null));
        AssertUtils.assertTrue(added, "name is duplicated.");
        return this;
    }

    public Class<?> toClass() throws CannotCompileException, NotFoundException {
        return this.toCtClass().toClass();
    }

    protected CtClass toCtClass() throws CannotCompileException, NotFoundException {
        CtClass cc = this.classPool.makeClass(this.className);
        this.addSerialize(cc);
        for (PojoField field : this.fields) {
            CtField ctField = new CtField(this.classPool.get(field.type.getName()), field.name, cc);
            ctField.setModifiers(1);
            if (field.initialValue == null) {
                cc.addField(ctField);
            } else {
                cc.addField(ctField, field.initialValue);
            }
            cc.addMethod(CtMethod.make((String)PojoBuilder.buildGetterSource(field.name, field.type), (CtClass)cc));
            cc.addMethod(CtMethod.make((String)PojoBuilder.buildSetterSource(field.name, field.type), (CtClass)cc));
        }
        cc.addMethod(CtMethod.make((String)this.buildHashCodeSource(), (CtClass)cc));
        cc.addMethod(CtMethod.make((String)this.buildEqualsSource(), (CtClass)cc));
        cc.addMethod(CtMethod.make((String)this.buildToStringSource(), (CtClass)cc));
        return cc;
    }

    protected void addSerialize(CtClass cc) throws CannotCompileException, NotFoundException {
        cc.addInterface(this.classPool.get(Serializable.class.getName()));
        cc.addField(CtField.make((String)"private static final long serialVersionUID = 1L;", (CtClass)cc));
    }

    private static String buildGetterSource(String fieldName, Class<?> type) {
        String getterName = PojoBuilder.buildGetterName(fieldName, type);
        StringBuilder source = new StringBuilder();
        source.append("public ").append(type.getName()).append(" ").append(getterName).append("() {");
        source.append(" return this.").append(fieldName).append(";");
        source.append("}");
        return source.toString();
    }

    private static String buildSetterSource(String fieldName, Class<?> type) {
        String setterName = PojoBuilder.buildSetterName(fieldName, type);
        StringBuilder source = new StringBuilder();
        source.append("public void ").append(setterName).append("(").append(type.getName()).append(" ").append(fieldName).append(") {");
        source.append(" this.").append(fieldName).append(" = ").append(fieldName).append(";");
        source.append("}");
        return source.toString();
    }

    private String buildHashCodeSource() {
        StringBuilder source = new StringBuilder();
        source.append("public int hashCode() {");
        source.append(" int hash = 1, p = 31;");
        for (PojoField field : this.fields) {
            if (!field.key) continue;
            String providingHashMethod = field.type.isPrimitive() ? TypeUtils.wrap(field.type).getName() : "java.util.Objects";
            source.append(" hash = p * hash + ").append(providingHashMethod).append(".hashCode(this.").append(field.name).append(");");
        }
        source.append(" return hash;");
        source.append("}");
        return source.toString();
    }

    private String buildEqualsSource() {
        StringBuilder source = new StringBuilder();
        source.append("public boolean equals(Object obj) {");
        source.append(" if (obj == null) return false;");
        source.append(" if (obj.getClass() != this.getClass()) return false;");
        source.append(" ").append(this.className).append(" another = (").append(this.className).append(") obj;");
        StringBuilder eqExpr = new StringBuilder();
        for (PojoField field : this.fields) {
            if (!field.key) continue;
            if (eqExpr.length() > 0) {
                eqExpr.append(" && ");
            }
            if (field.type.isPrimitive()) {
                eqExpr.append("this.").append(field.name).append(" == another.").append(field.name);
                continue;
            }
            eqExpr.append("java.util.Objects.equals(this.").append(field.name).append(", another.").append(field.name).append(")");
        }
        source.append(" return ").append(eqExpr.toString()).append(";");
        source.append("}");
        return source.toString();
    }

    protected String buildToStringSource() {
        StringBuilder source = new StringBuilder();
        source.append("public String toString() {");
        source.append(" return new ").append(ToStringBuilder.class.getName()).append("().toString(this);");
        source.append("}");
        return source.toString();
    }

    private static String buildGetterName(String fieldName, Class<?> type) {
        if (type != Boolean.TYPE) {
            return "get" + StringUtils.firstUpperCase(fieldName);
        }
        if (!fieldName.startsWith("is")) {
            return "is" + StringUtils.firstUpperCase(fieldName);
        }
        return fieldName;
    }

    private static String buildSetterName(String fieldName, Class<?> type) {
        if (type != Boolean.TYPE) {
            return "set" + StringUtils.firstUpperCase(fieldName);
        }
        if (!fieldName.startsWith("is")) {
            return "set" + StringUtils.firstUpperCase(fieldName);
        }
        return "set" + StringUtils.firstUpperCase(fieldName.substring(2));
    }

    public static Object get(Object obj, String fieldName) throws ReflectionException {
        AssertUtils.assertNotNull(obj);
        Field field = ReflectionUtils.findField(obj.getClass(), fieldName);
        AssertUtils.assertNotNull(field);
        return ReflectionUtils.get(field, obj);
    }

    public static void set(Object obj, String fieldName, Object value) throws ReflectionException {
        AssertUtils.assertNotNull(obj);
        Field field = ReflectionUtils.findField(obj.getClass(), fieldName);
        AssertUtils.assertNotNull(field);
        ReflectionUtils.set(field, obj, value);
    }

    protected static class PojoField {
        final String name;
        final Class<?> type;
        final boolean key;
        final String initialValue;

        public PojoField(String name, Class<?> type, boolean key, String initialValue) {
            this.name = name;
            this.type = type;
            this.key = key;
            this.initialValue = initialValue;
        }

        public int hashCode() {
            int hash = 1;
            int p = 31;
            hash = p * hash + Objects.hashCode(this.name);
            return hash;
        }

        public boolean equals(Object obj) {
            PojoField another = (PojoField)obj;
            return this.name.equals(another.name);
        }
    }
}

