/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TypeUtils {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP;
    private static final Map<Class<?>, Class<?>> WRAPPER_PRIMITIVE_MAP;

    private static void add(Map<Class<?>, Class<?>> forward, Map<Class<?>, Class<?>> backward, Class<?> key, Class<?> value) {
        forward.put(key, value);
        backward.put(value, key);
    }

    public static Set<Class<?>> allPrimitiveTypes() {
        return PRIMITIVE_WRAPPER_MAP.keySet();
    }

    public static Set<Class<?>> allWrapperTypes() {
        return WRAPPER_PRIMITIVE_MAP.keySet();
    }

    public static boolean isWrapperType(Class<?> type) {
        return WRAPPER_PRIMITIVE_MAP.containsKey(type);
    }

    public static Class<?> wrap(Class<?> type) {
        Class<?> wrapped = PRIMITIVE_WRAPPER_MAP.get(type);
        return wrapped == null ? type : wrapped;
    }

    public static Class<?> unwrap(Class<?> type) {
        Class<?> unwrapped = WRAPPER_PRIMITIVE_MAP.get(type);
        return unwrapped == null ? type : unwrapped;
    }

    static {
        HashMap primToWrap = new HashMap();
        HashMap wrapToPrim = new HashMap();
        TypeUtils.add(primToWrap, wrapToPrim, Boolean.TYPE, Boolean.class);
        TypeUtils.add(primToWrap, wrapToPrim, Byte.TYPE, Byte.class);
        TypeUtils.add(primToWrap, wrapToPrim, Character.TYPE, Character.class);
        TypeUtils.add(primToWrap, wrapToPrim, Double.TYPE, Double.class);
        TypeUtils.add(primToWrap, wrapToPrim, Float.TYPE, Float.class);
        TypeUtils.add(primToWrap, wrapToPrim, Integer.TYPE, Integer.class);
        TypeUtils.add(primToWrap, wrapToPrim, Long.TYPE, Long.class);
        TypeUtils.add(primToWrap, wrapToPrim, Short.TYPE, Short.class);
        TypeUtils.add(primToWrap, wrapToPrim, Void.TYPE, Void.class);
        PRIMITIVE_WRAPPER_MAP = Collections.unmodifiableMap(primToWrap);
        WRAPPER_PRIMITIVE_MAP = Collections.unmodifiableMap(wrapToPrim);
    }
}

