/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.StringWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static int copy(InputStream is, OutputStream os) throws IOException {
        int count = 0;
        byte[] buf = new byte[4096];
        int c = -1;
        while ((c = is.read(buf)) != -1) {
            os.write(buf, 0, c);
            count += c;
        }
        return count;
    }

    public static void copy(byte[] src, int copyLength, OutputStream os) throws IOException {
        int c;
        byte[] buf = new byte[4096];
        for (int count = 0; count < copyLength; count += c) {
            int left = copyLength - count;
            c = left >= buf.length ? buf.length : left;
            System.arraycopy(src, count, buf, 0, c);
            os.write(buf, 0, c);
        }
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
        IOUtils.copy(is, os);
        return os.toByteArray();
    }

    public static int copy(Reader r, Writer w) throws IOException {
        int count = 0;
        char[] buf = new char[2048];
        int c = -1;
        while ((c = r.read(buf)) != -1) {
            w.write(buf, 0, c);
            count += c;
        }
        return count;
    }

    public static String toString(Reader r) throws IOException {
        StringWriter os = new StringWriter();
        IOUtils.copy(r, os);
        return os.toString();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static InputStream nonClosing(InputStream in) {
        return new FilterInputStream(in){

            @Override
            public void close() throws IOException {
            }
        };
    }

    public static OutputStream nonClosing(OutputStream out) {
        return new FilterOutputStream(out){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void write(byte[] b, int off, int let) throws IOException {
                this.out.write(b, off, let);
            }
        };
    }
}

