/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.Compat;
import com.appslandia.common.utils.SplitUtils;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;

public class CharsetUtils {
    @Compat
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    @Compat
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    @Compat
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    @Compat
    public static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    @Compat
    public static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    @Compat
    public static final Charset UTF_16 = Charset.forName("UTF-16");

    public static String parseCharset(String contentType) {
        return CharsetUtils.parseCharset(contentType, UTF_8.name());
    }

    public static String parseCharset(String contentType, String defaultCharset) {
        if (contentType == null) {
            return defaultCharset;
        }
        List<String> items = SplitUtils.split(contentType, ';');
        for (int i = items.size() - 1; i >= 0; --i) {
            String item = items.get(i);
            if (!item.toLowerCase(Locale.ENGLISH).startsWith("charset=")) continue;
            return item.substring(8);
        }
        return defaultCharset;
    }
}

