/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.StringUtils;

public class AssertUtils {
    public static void assertTrue(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void assertTrue(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static <T> T assertNotNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static <T> T assertNotNull(T obj, String errorMessage) {
        if (obj == null) {
            throw new NullPointerException(errorMessage);
        }
        return obj;
    }

    public static void assertNull(Object obj) {
        if (obj != null) {
            throw new IllegalArgumentException();
        }
    }

    public static void assertNull(Object obj, String errorMessage) {
        if (obj != null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void assertState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void assertState(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public static String assertNotBlank(String text) {
        if ((text = StringUtils.trimToNull(text)) == null) {
            throw new IllegalArgumentException();
        }
        return text;
    }

    public static String assertNotBlank(String text, String errorMessage) {
        if ((text = StringUtils.trimToNull(text)) == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        return text;
    }
}

