/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.streams;

import com.appslandia.common.streams.NoResultException;
import com.appslandia.common.streams.NonUniqueResultException;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class CollectorUtils {
    static final Set<Collector.Characteristics> CH_NOID = Collections.emptySet();

    public static <T> Collector<T, ?, T> single() {
        return new CollectorImpl(NonUniqueResultCheckingConsumer::new, NonUniqueResultCheckingConsumer::accept, null, new NoResultCheckingFunction(), CH_NOID);
    }

    public static <T> Collector<T, ?, T> singleOrNull() {
        return new CollectorImpl<Object, NonUniqueResultCheckingConsumer, Object>(NonUniqueResultCheckingConsumer::new, NonUniqueResultCheckingConsumer::accept, null, f -> f.result, CH_NOID);
    }

    static class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        final Supplier<A> supplier;
        final BiConsumer<A, T> accumulator;
        final BinaryOperator<A> combiner;
        final Function<A, R> finisher;
        final Set<Collector.Characteristics> characteristics;

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.characteristics = characteristics;
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }

    static class NoResultCheckingFunction<T>
    implements Function<NonUniqueResultCheckingConsumer<T>, T> {
        NoResultCheckingFunction() {
        }

        @Override
        public T apply(NonUniqueResultCheckingConsumer<T> t) {
            if (t.result == null) {
                throw new NoResultException();
            }
            return t.result;
        }
    }

    static class NonUniqueResultCheckingConsumer<T>
    implements Consumer<T> {
        T result = null;

        NonUniqueResultCheckingConsumer() {
        }

        @Override
        public void accept(T obj) {
            if (this.result != null) {
                throw new NonUniqueResultException();
            }
            this.result = obj;
        }
    }
}

