/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;

public class OffsetTimeAdapter
implements JsonSerializer<OffsetTime>,
JsonDeserializer<OffsetTime> {
    final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSSXXX");

    public JsonElement serialize(OffsetTime src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(this.formatter.format(src));
    }

    public OffsetTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return OffsetTime.parse(json.getAsString(), this.formatter);
    }
}

