/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.formatters.BigDecimalFormatter;
import com.appslandia.common.formatters.BigIntegerFormatter;
import com.appslandia.common.formatters.BooleanFormatter;
import com.appslandia.common.formatters.ByteFormatter;
import com.appslandia.common.formatters.CharacterFormatter;
import com.appslandia.common.formatters.DoubleFormatter;
import com.appslandia.common.formatters.FloatFormatter;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.FormatterId;
import com.appslandia.common.formatters.IntegerFormatter;
import com.appslandia.common.formatters.LongFormatter;
import com.appslandia.common.formatters.ShortFormatter;
import com.appslandia.common.formatters.SqlDateFormatter;
import com.appslandia.common.formatters.SqlDateTime24HFormatter;
import com.appslandia.common.formatters.SqlDateTimeFormatter;
import com.appslandia.common.formatters.SqlTime24HFormatter;
import com.appslandia.common.formatters.SqlTimeFormatter;
import com.appslandia.common.utils.TypeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FormatterProvider
extends InitializeObject {
    private Map<String, Formatter> formatterMap;

    public static FormatterProvider getDefault() {
        return FormatterProviderHolder.DEFAULT;
    }

    public FormatterProvider() {
        HashMap<String, Formatter> map = new HashMap<String, Formatter>();
        map.put(Formatter.BYTE, new ByteFormatter());
        map.put(Formatter.SHORT, new ShortFormatter());
        map.put(Formatter.INTEGER, new IntegerFormatter());
        map.put(Formatter.LONG, new LongFormatter());
        map.put(Formatter.BIGINTEGER, new BigIntegerFormatter());
        map.put(Formatter.FLOAT, new FloatFormatter());
        map.put(Formatter.DOUBLE, new DoubleFormatter());
        map.put(Formatter.BIGDECIMAL, new BigDecimalFormatter());
        map.put(Formatter.SQL_DATE, new SqlDateFormatter());
        map.put(Formatter.SQL_TIME, new SqlTimeFormatter());
        map.put(Formatter.SQL_DATETIME, new SqlDateTimeFormatter());
        map.put("Time24H", new SqlTime24HFormatter());
        map.put("DateTime24H", new SqlDateTime24HFormatter());
        map.put(Formatter.BOOLEAN, new BooleanFormatter());
        map.put(Formatter.CHARACTER, new CharacterFormatter());
        this.formatterMap = map;
    }

    @Override
    protected void init() throws Exception {
        this.formatterMap = Collections.unmodifiableMap(this.formatterMap);
    }

    public void putFormatter(String id, Formatter formatter) {
        this.assertNotInitialized();
        this.formatterMap.put(id, formatter);
    }

    public Formatter findFormatter(Class<?> targetType, FormatterId formatterId) {
        this.initialize();
        if (formatterId != null) {
            return this.getFormatter(formatterId.value());
        }
        String id = TypeUtils.wrap(targetType).getSimpleName();
        return this.formatterMap.get(id);
    }

    public Formatter getFormatter(Class<?> targetType) throws IllegalArgumentException {
        this.initialize();
        String id = TypeUtils.wrap(targetType).getSimpleName();
        Formatter formatter = this.formatterMap.get(id);
        if (formatter == null) {
            throw new IllegalArgumentException("Formatter is required (targetType=" + targetType + ")");
        }
        return formatter;
    }

    public Formatter getFormatter(String id) throws IllegalArgumentException {
        this.initialize();
        Formatter formatter = this.formatterMap.get(id);
        if (formatter == null) {
            throw new IllegalArgumentException("Formatter is required (id=" + id + ")");
        }
        return formatter;
    }

    private static final class FormatterProviderHolder {
        static final FormatterProvider DEFAULT = new FormatterProvider();

        private FormatterProviderHolder() {
        }
    }
}

