/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.easyrecord;

import com.appslandia.common.easyrecord.Field;
import com.appslandia.common.easyrecord.Record;
import com.appslandia.common.easyrecord.RecordUtils;
import com.appslandia.common.easyrecord.Table;
import com.appslandia.common.jdbc.StatementImpl;
import com.appslandia.common.utils.AssertUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;

public class DbManager
implements AutoCloseable {
    private Connection conn;
    private boolean closeConn;
    private StatementImpl insertStat;
    private StatementImpl updateStat;
    private StatementImpl deleteStat;
    private StatementImpl getStat;
    private StatementImpl existsStat;
    private boolean closed = false;
    private static DataSource __dataSource;

    public DbManager() throws SQLException {
        this(DbManager.getDataSource());
    }

    public DbManager(Connection conn) {
        this.conn = conn;
        this.closeConn = false;
    }

    public DbManager(DataSource dataSource) throws SQLException {
        AssertUtils.assertNotNull(dataSource);
        this.conn = dataSource.getConnection();
        this.closeConn = true;
    }

    public Connection getConnection() {
        return this.conn;
    }

    protected Object toSqlObject(Object val, int sqlType) {
        if (val == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(val.getClass())) {
            if (val.getClass() == java.sql.Date.class || val.getClass() == Time.class || val.getClass() == Timestamp.class) {
                return val;
            }
            if (sqlType == 92) {
                return new Time(((Date)val).getTime());
            }
            if (sqlType == 93) {
                return new Timestamp(((Date)val).getTime());
            }
            return new java.sql.Date(((Date)val).getTime());
        }
        return val;
    }

    public int insert(Record record, Table table) throws SQLException {
        return this.insert(record, table, false);
    }

    public void insertBatch(Record record, Table table) throws SQLException {
        this.insert(record, table, true);
    }

    protected void setParameter(StatementImpl stat, String parameterName, Object val, int sqlType) throws SQLException {
        if (val != null) {
            stat.setObject(parameterName, val);
        } else if (sqlType > 0) {
            stat.setNull(parameterName, sqlType);
        } else {
            stat.setObject(parameterName, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int insert(Record record, Table table, boolean addBatch) throws SQLException {
        this.assertNoClosed();
        if (this.insertStat == null) {
            this.insertStat = new StatementImpl(this.conn, table.getInsertSql(), table.getAutoKey() != null);
        }
        for (Field field : table.getFields()) {
            if (field.isAutoKey()) continue;
            Object t = record.get(field.getName());
            Object object = this.toSqlObject(t, field.getSqlType());
            this.setParameter(this.insertStat, field.getName(), object, field.getSqlType());
        }
        int rowAffected = -1;
        if (!addBatch) {
            rowAffected = this.insertStat.executeUpdate();
            if (table.getAutoKey() == null) return rowAffected;
            Throwable throwable = null;
            try (ResultSet rs = this.insertStat.getGeneratedKeys();){
                if (!rs.next()) return rowAffected;
                Object generatedKey = rs.getObject(1);
                record.set(table.getAutoKey().getName(), generatedKey);
                return rowAffected;
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        } else {
            this.insertStat.addBatch();
        }
        return rowAffected;
    }

    public int update(Record record, Table table) throws SQLException {
        return this.update(record, table, false);
    }

    public void updateBatch(Record record, Table table) throws SQLException {
        this.update(record, table, true);
    }

    protected int update(Record record, Table table, boolean addBatch) throws SQLException {
        this.assertNoClosed();
        if (this.updateStat == null) {
            this.updateStat = new StatementImpl(this.conn, table.getUpdateSql());
        }
        for (Field field : table.getFields()) {
            if (!field.isKey() && !field.isUpdatable()) continue;
            Object val = record.get(field.getName());
            val = this.toSqlObject(val, field.getSqlType());
            this.setParameter(this.updateStat, field.getName(), val, field.getSqlType());
        }
        int rowAffected = -1;
        if (!addBatch) {
            rowAffected = this.updateStat.executeUpdate();
        } else {
            this.updateStat.addBatch();
        }
        return rowAffected;
    }

    public int delete(Record key, Table table) throws SQLException {
        return this.delete(key, table, false);
    }

    public void deleteBatch(Record key, Table table) throws SQLException {
        this.delete(key, table, true);
    }

    protected int delete(Record key, Table table, boolean addBatch) throws SQLException {
        this.assertNoClosed();
        if (this.deleteStat == null) {
            this.deleteStat = new StatementImpl(this.conn, table.getDeleteSql());
        }
        for (Field field : table.getFields()) {
            if (!field.isKey()) continue;
            Object val = key.get(field.getName());
            val = this.toSqlObject(val, field.getSqlType());
            this.setParameter(this.deleteStat, field.getName(), val, field.getSqlType());
        }
        int rowAffected = -1;
        if (!addBatch) {
            rowAffected = this.deleteStat.executeUpdate();
        } else {
            this.deleteStat.addBatch();
        }
        return rowAffected;
    }

    public Record getRecord(Record key, Table table) throws SQLException {
        this.assertNoClosed();
        if (this.getStat == null) {
            this.getStat = new StatementImpl(this.conn, table.getGetSql());
        }
        for (Field field : table.getFields()) {
            if (!field.isKey()) continue;
            Object val = key.get(field.getName());
            val = this.toSqlObject(val, field.getSqlType());
            this.setParameter(this.getStat, field.getName(), val, field.getSqlType());
        }
        return RecordUtils.executeSingle(this.getStat);
    }

    public boolean exists(Record key, Table table) throws SQLException {
        this.assertNoClosed();
        if (this.existsStat == null) {
            this.existsStat = new StatementImpl(this.conn, table.getExistsSql());
        }
        for (Field field : table.getFields()) {
            if (!field.isKey()) continue;
            Object val = key.get(field.getName());
            val = this.toSqlObject(val, field.getSqlType());
            this.setParameter(this.existsStat, field.getName(), val, field.getSqlType());
        }
        Integer count = (Integer)this.existsStat.executeScalar();
        return count == 1;
    }

    /*
     * Exception decompiling
     */
    public List<Record> getAll(Table table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void executeBatch() throws SQLException {
        this.assertNoClosed();
        AssertUtils.assertTrue(!this.conn.getAutoCommit());
        if (this.insertStat != null) {
            this.insertStat.executeBatch();
        }
        if (this.updateStat != null) {
            this.updateStat.executeBatch();
        }
        if (this.deleteStat != null) {
            this.deleteStat.executeBatch();
        }
    }

    public void beginTransaction() throws SQLException {
        this.assertNoClosed();
        this.conn.setAutoCommit(false);
    }

    public void commit() throws SQLException {
        this.assertNoClosed();
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.assertNoClosed();
        this.conn.rollback();
    }

    protected void assertNoClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException(this + " closed.");
        }
    }

    private static void tryClose(PreparedStatement stat) throws SQLException {
        if (stat != null && !stat.isClosed()) {
            stat.close();
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            DbManager.tryClose(this.insertStat);
            DbManager.tryClose(this.updateStat);
            DbManager.tryClose(this.deleteStat);
            DbManager.tryClose(this.getStat);
            DbManager.tryClose(this.existsStat);
            if (this.closeConn) {
                this.conn.close();
            }
            this.closed = true;
        }
    }

    public static DataSource getDataSource() {
        return AssertUtils.assertNotNull(__dataSource);
    }

    public static void setDataSource(DataSource dataSource) {
        AssertUtils.assertNull(dataSource);
        __dataSource = dataSource;
    }
}

