/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.TokenGenerator;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.TextDigester;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ValueUtils;

public class TokenDigester
extends InitializeObject {
    private int tokenLength;
    private TokenGenerator generator;
    private TextDigester digester;

    public TokenDigester() {
    }

    public TokenDigester(TextDigester digester) {
        this.digester = digester;
    }

    public TokenDigester(TextDigester digester, int tokenLength) {
        this.digester = digester;
        this.tokenLength = tokenLength;
    }

    @Override
    protected void init() throws Exception {
        this.tokenLength = ValueUtils.defaultIfNotSet(this.tokenLength, 32);
        AssertUtils.assertTrue(this.tokenLength > 0, "tokenLength is required.");
        this.generator = new TokenGenerator(this.tokenLength);
        AssertUtils.assertNotNull(this.digester, "digester is required.");
    }

    public String generate() throws CryptoException {
        this.initialize();
        return this.generator.generate();
    }

    public String digest(String token) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(token, "token is required.");
        return this.digester.digest(token);
    }

    public boolean verify(String token, String digested) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(token, "token is required.");
        AssertUtils.assertNotNull(digested, "digested is required.");
        return this.digester.verify(token, digested);
    }

    public TokenDigester setTokenLength(int tokenLength) {
        this.assertNotInitialized();
        this.tokenLength = tokenLength;
        return this;
    }

    public TokenDigester setDigester(TextDigester digester) {
        this.assertNotInitialized();
        this.digester = digester;
        return this;
    }

    public TokenDigester copy() {
        TokenDigester impl = new TokenDigester().setTokenLength(this.tokenLength);
        if (this.digester != null) {
            impl.digester = this.digester.copy();
        }
        return impl;
    }
}

