/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.BaseEncodingUtils;
import com.appslandia.common.utils.CharsetUtils;
import com.appslandia.common.utils.StringUtils;
import com.appslandia.common.utils.ValueUtils;
import java.nio.charset.Charset;

public abstract class TextBasedCrypto
extends InitializeObject {
    protected Charset textCharset;
    protected String baseEncoding;

    @Override
    protected void init() throws Exception {
        this.textCharset = ValueUtils.defaultIfNotSet(this.textCharset, CharsetUtils.UTF_8);
        this.baseEncoding = ValueUtils.defaultIfNotSet(this.baseEncoding, "base64");
        AssertUtils.assertTrue(BaseEncodingUtils.isEncodingSupported(this.baseEncoding), "baseEncoding is not supported.");
    }

    public TextBasedCrypto setTextCharset(Charset charset) {
        this.assertNotInitialized();
        this.textCharset = charset;
        return this;
    }

    public TextBasedCrypto setTextCharset(String textCharset) {
        this.assertNotInitialized();
        String cs = StringUtils.trimToNull(textCharset);
        if (cs != null) {
            this.textCharset = Charset.forName(cs);
        }
        return this;
    }

    public TextBasedCrypto setBaseEncoding(String baseEncoding) {
        this.assertNotInitialized();
        this.baseEncoding = StringUtils.trimToNull(baseEncoding);
        return this;
    }
}

