/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.PropertyMap;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.PbeEncryptor;
import com.appslandia.common.crypto.TextEncryptor;
import com.appslandia.common.utils.CharsetUtils;
import com.appslandia.common.utils.DateUtils;
import com.appslandia.common.utils.StringUtils;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Normalizer;
import javax.crypto.Cipher;

public class SecureProperties
extends PropertyMap {
    private static final long serialVersionUID = 1L;
    final TextEncryptor textEncryptor;
    private static final String ENC_BEGIN = "ENC(";
    private static final String ENC_END = ")";

    public SecureProperties() {
        char[] pw = CryptoUtils.toCharArray(Cipher.class.getName().getBytes(CharsetUtils.ISO_8859_1));
        char[] np = Normalizer.normalize(new String(pw), Normalizer.Form.NFC).toCharArray();
        try {
            this.textEncryptor = new TextEncryptor(new PbeEncryptor().setTransformation("AES/CBC/PKCS5Padding").setKeySize(16).setPassword(np));
        }
        finally {
            CryptoUtils.clear(np);
            CryptoUtils.clear(pw);
        }
    }

    public SecureProperties(char[] password) {
        this.textEncryptor = new TextEncryptor(new PbeEncryptor().setTransformation("AES/CBC/PKCS5Padding").setKeySize(16).setPassword(password));
    }

    public SecureProperties(TextEncryptor textEncryptor) {
        this.textEncryptor = textEncryptor;
    }

    @Override
    public String get(Object key) throws CryptoException {
        String value = super.get(key);
        if (value == null) {
            return null;
        }
        if (!SecureProperties.isEncryptedValue(value)) {
            return value;
        }
        return this.textEncryptor.decrypt(SecureProperties.parseEncryptedValue(value));
    }

    private void doSecure(String key, String value) throws CryptoException {
        this.props.put(key, value != null ? SecureProperties.markEncryptedValue(this.textEncryptor.encrypt(value)) : null);
    }

    public void secure(String key, String value) throws CryptoException {
        this.doSecure(key, StringUtils.trimToNull(value));
    }

    public void secure(String key, boolean value) throws CryptoException {
        this.doSecure(key, Boolean.toString(value));
    }

    public void secure(String key, int value) throws CryptoException {
        this.doSecure(key, Integer.toString(value));
    }

    public void secure(String key, long value) throws CryptoException {
        this.doSecure(key, Long.toString(value));
    }

    public void secure(String key, float value) throws CryptoException {
        this.doSecure(key, Float.toString(value));
    }

    public void secure(String key, double value) throws CryptoException {
        this.doSecure(key, Double.toString(value));
    }

    public void secure(String key, Boolean value) throws CryptoException {
        this.doSecure(key, value != null ? value.toString() : null);
    }

    public void secure(String key, Integer value) throws CryptoException {
        this.doSecure(key, value != null ? value.toString() : null);
    }

    public void secure(String key, Long value) throws CryptoException {
        this.doSecure(key, value != null ? value.toString() : null);
    }

    public void secure(String key, Float value) throws CryptoException {
        this.doSecure(key, value != null ? value.toString() : null);
    }

    public void secure(String key, Double value) throws CryptoException {
        this.doSecure(key, value != null ? value.toString() : null);
    }

    public void secure(String key, Date value) throws CryptoException {
        this.doSecure(key, value != null ? DateUtils.iso8601Date(value) : null);
    }

    public void secure(String key, Time value) throws CryptoException {
        this.doSecure(key, value != null ? DateUtils.iso8601Time(value) : null);
    }

    public void secure(String key, Timestamp value) throws CryptoException {
        this.doSecure(key, value != null ? DateUtils.iso8601DateTime(value) : null);
    }

    private static String markEncryptedValue(String value) {
        return ENC_BEGIN + value + ENC_END;
    }

    private static boolean isEncryptedValue(String value) {
        return value.startsWith(ENC_BEGIN) && value.endsWith(ENC_END);
    }

    private static String parseEncryptedValue(String value) {
        return value.substring(ENC_BEGIN.length(), value.length() - ENC_END.length());
    }
}

