/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.utils.StringUtils;
import com.appslandia.common.utils.ValueUtils;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class SecretKeyGenerator
extends InitializeObject {
    private String algorithm;
    private String provider;
    private SecretKeyFactory secretKeyFactory;

    public SecretKeyGenerator() {
    }

    public SecretKeyGenerator(String algorithm) {
        this.algorithm = algorithm;
    }

    public SecretKeyGenerator(String algorithm, String provider) {
        this.algorithm = algorithm;
        this.provider = provider;
    }

    @Override
    protected void init() throws Exception {
        this.algorithm = ValueUtils.defaultIfNotSet(this.algorithm, "PBKDF2WithHmacSHA512");
        this.secretKeyFactory = this.provider == null ? SecretKeyFactory.getInstance(this.algorithm) : SecretKeyFactory.getInstance(this.algorithm, this.provider);
    }

    public byte[] generate(char[] password, byte[] salt, int iterationCount, int keySize) throws CryptoException {
        this.initialize();
        PBEKeySpec keySpec = new PBEKeySpec(password, salt, iterationCount, keySize * 8);
        SecretKey secretkey = null;
        try {
            secretkey = this.secretKeyFactory.generateSecret(keySpec);
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        finally {
            keySpec.clearPassword();
        }
        byte[] encoded = secretkey.getEncoded();
        CryptoUtils.tryDestroy(secretkey);
        return encoded;
    }

    public SecretKeyGenerator setAlgorithm(String algorithm) {
        this.assertNotInitialized();
        this.algorithm = StringUtils.trimToNull(algorithm);
        return this;
    }

    public SecretKeyGenerator setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = StringUtils.trimToNull(provider);
        return this;
    }

    public SecretKeyGenerator copy() {
        return new SecretKeyGenerator().setAlgorithm(this.algorithm).setProvider(this.provider);
    }
}

