/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.Encryptor;
import com.appslandia.common.crypto.PbeCrypto;
import com.appslandia.common.crypto.SecretKeyGenerator;
import com.appslandia.common.crypto.SecureString;
import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.RandomUtils;
import com.appslandia.common.utils.StringUtils;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class PbeEncryptor
extends PbeCrypto
implements Encryptor {
    private String transformation;
    private String provider;
    private String algorithm;
    private boolean initVector;
    private Cipher cipher;
    final Object mutex = new Object();
    final Random random = new SecureRandom();

    @Override
    protected void init() throws Exception {
        super.init();
        AssertUtils.assertNotNull(this.transformation, "transformation is required.");
        this.algorithm = PbeEncryptor.parseAlgorithm(this.transformation);
        this.initVector = PbeEncryptor.requireIV(this.transformation.toLowerCase(Locale.ENGLISH));
        AssertUtils.assertTrue(this.keySize > 0, "keySize is required.");
        if (this.secretKeyGenerator == null) {
            this.secretKeyGenerator = new SecretKeyGenerator();
        }
        this.cipher = this.provider == null ? Cipher.getInstance(this.transformation) : Cipher.getInstance(this.transformation, this.provider);
    }

    private static String parseAlgorithm(String spec) {
        int idx = spec.indexOf(47);
        return idx > 0 ? spec.substring(0, idx) : spec;
    }

    private static boolean requireIV(String spec) {
        return spec.contains("cbc") || spec.contains("cfb") || spec.contains("ofb") || spec.contains("ctr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        byte[] iv = null;
        if (this.initVector) {
            iv = RandomUtils.nextBytes(this.random, this.cipher.getBlockSize());
        }
        byte[] salt = RandomUtils.nextBytes(this.random, this.saltSize);
        byte[] encMsg = null;
        SecretKey secretKey = this.createSecretKey(salt, this.algorithm);
        try {
            Object object = this.mutex;
            synchronized (object) {
                if (iv != null) {
                    this.cipher.init(1, (Key)secretKey, new IvParameterSpec(iv));
                } else {
                    this.cipher.init(1, secretKey);
                }
                encMsg = this.cipher.doFinal(message);
            }
            if (iv != null) {
                object = ArrayUtils.append(iv, salt, encMsg);
                return object;
            }
            object = ArrayUtils.append(salt, encMsg);
            return object;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        finally {
            CryptoUtils.tryDestroy(secretKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        byte[] iv = null;
        int msgLen = message.length;
        if (this.initVector) {
            AssertUtils.assertTrue(msgLen > this.cipher.getBlockSize() + this.saltSize, "message is invalid.");
            msgLen = msgLen - this.cipher.getBlockSize() - this.saltSize;
            iv = new byte[this.cipher.getBlockSize()];
        } else {
            AssertUtils.assertTrue(msgLen > this.saltSize, "message is invalid.");
            msgLen -= this.saltSize;
        }
        byte[] salt = new byte[this.saltSize];
        byte[] msg = new byte[msgLen];
        if (iv != null) {
            ArrayUtils.copy(message, iv, salt, msg);
        } else {
            ArrayUtils.copy(message, salt, msg);
        }
        SecretKey secretKey = this.createSecretKey(salt, this.algorithm);
        try {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    if (iv != null) {
                        this.cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
                    } else {
                        this.cipher.init(2, secretKey);
                    }
                    byte[] byArray = this.cipher.doFinal(msg);
                    return byArray;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (GeneralSecurityException ex) {
                        throw new CryptoException(ex);
                    }
                }
            }
        }
        finally {
            CryptoUtils.tryDestroy(secretKey);
        }
    }

    public PbeEncryptor setTransformation(String transformation) {
        this.assertNotInitialized();
        this.transformation = StringUtils.trimToNull(transformation);
        return this;
    }

    public PbeEncryptor setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = StringUtils.trimToNull(provider);
        return this;
    }

    @Override
    public PbeEncryptor setSaltSize(int saltSize) {
        super.setSaltSize(saltSize);
        return this;
    }

    @Override
    public PbeEncryptor setIterationCount(int iterationCount) {
        super.setIterationCount(iterationCount);
        return this;
    }

    @Override
    public PbeEncryptor setKeySize(int keySize) {
        super.setKeySize(keySize);
        return this;
    }

    @Override
    public PbeEncryptor setSecurePassword(SecureString password) {
        super.setSecurePassword(password);
        return this;
    }

    @Override
    public PbeEncryptor setSecurePassword(char[] password) {
        super.setSecurePassword(password);
        return this;
    }

    @Override
    public PbeEncryptor setPassword(char[] password) {
        super.setPassword(password);
        return this;
    }

    @Override
    public PbeEncryptor setSecretKeyGenerator(SecretKeyGenerator secretKeyGenerator) {
        super.setSecretKeyGenerator(secretKeyGenerator);
        return this;
    }

    @Override
    public PbeEncryptor copy() {
        PbeEncryptor impl = new PbeEncryptor().setTransformation(this.transformation).setProvider(this.provider);
        impl.setSaltSize(this.saltSize).setIterationCount(this.iterationCount).setKeySize(this.keySize);
        if (this.password != null) {
            if (this.password instanceof SecureString) {
                impl.password = ((SecureString)this.password).copy();
            } else {
                impl.setPassword((char[])this.password);
            }
        }
        if (this.secretKeyGenerator != null) {
            impl.secretKeyGenerator = this.secretKeyGenerator.copy();
        }
        return impl;
    }
}

