/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.Permutation;
import com.appslandia.common.base.WordsGenerator;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharUtils;
import com.appslandia.common.utils.RandomUtils;
import java.security.SecureRandom;
import java.util.Random;

public class PasswordGenerator
extends InitializeObject {
    private static final char[] UPPER_CASES = CharUtils.toCharRange("A-Z");
    private static final char[] LOWER_CASES = CharUtils.toCharRange("a-z");
    private static final char[] DIGITS = CharUtils.toCharRange("0-9");
    private static final char[] SYMBOLS = "@#$%".toCharArray();
    private int upperCases;
    private int lowerCases;
    private int digits;
    private int symbols;
    final Random random = new SecureRandom();

    @Override
    protected void init() throws Exception {
        this.upperCases = Math.max(1, this.upperCases);
        this.lowerCases = Math.max(1, this.lowerCases);
        this.digits = Math.max(1, this.digits);
        this.symbols = Math.max(1, this.symbols);
    }

    public char[] generatePassword(int length) {
        AssertUtils.assertTrue(length >= 8, "length >= 8");
        return this.generatePassword(length, length);
    }

    public char[] generatePassword(int minLength, int maxLength) {
        this.initialize();
        AssertUtils.assertTrue(minLength <= maxLength, "maxLength >= minLength.");
        AssertUtils.assertTrue(minLength >= 8, "minLength >= 8");
        int length = RandomUtils.nextInt(this.random, minLength, maxLength);
        char[] pwdChars = new char[length];
        int emptyCount = length;
        Permutation perm = new Permutation(4);
        block10: while (perm.hasNext()) {
            int next = perm.next();
            switch (next) {
                case 0: {
                    emptyCount = WordsGenerator.randomChars(this.random, UPPER_CASES, pwdChars, this.upperCases, emptyCount);
                    continue block10;
                }
                case 1: {
                    emptyCount = WordsGenerator.randomChars(this.random, LOWER_CASES, pwdChars, this.lowerCases, emptyCount);
                    continue block10;
                }
                case 2: {
                    emptyCount = WordsGenerator.randomChars(this.random, DIGITS, pwdChars, this.digits, emptyCount);
                    continue block10;
                }
            }
            emptyCount = WordsGenerator.randomChars(this.random, SYMBOLS, pwdChars, this.symbols, emptyCount);
        }
        block11: for (int i = 0; i < length; ++i) {
            if (pwdChars[i] != '\u0000') continue;
            int src = this.random.nextInt(4);
            switch (src) {
                case 0: {
                    pwdChars[i] = UPPER_CASES[this.random.nextInt(UPPER_CASES.length)];
                    continue block11;
                }
                case 1: {
                    pwdChars[i] = LOWER_CASES[this.random.nextInt(LOWER_CASES.length)];
                    continue block11;
                }
                case 2: {
                    pwdChars[i] = DIGITS[this.random.nextInt(DIGITS.length)];
                    continue block11;
                }
                default: {
                    pwdChars[i] = SYMBOLS[this.random.nextInt(SYMBOLS.length)];
                }
            }
        }
        return pwdChars;
    }

    public PasswordGenerator setUpperCases(int upperCases) {
        this.assertNotInitialized();
        this.upperCases = upperCases;
        return this;
    }

    public PasswordGenerator setLowerCases(int lowerCases) {
        this.assertNotInitialized();
        this.lowerCases = lowerCases;
        return this;
    }

    public PasswordGenerator setDigits(int digits) {
        this.assertNotInitialized();
        this.digits = digits;
        return this;
    }

    public PasswordGenerator setSymbols(int symbols) {
        this.assertNotInitialized();
        this.symbols = symbols;
        return this;
    }
}

