/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.StringUtils;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class KeyStoreUtil
extends InitializeObject {
    public static final String TYPE_JCEKS = "JCEKS";
    public static final String TYPE_JKS = "JKS";
    public static final String TYPE_PKCS12 = "PKCS12";
    private String type;
    private String provider;
    private KeyStore keyStore;
    private char[] password;
    private InputStream inputStream;
    private KeyStore.ProtectionParameter protectionParameter = null;

    public KeyStoreUtil() {
    }

    public KeyStoreUtil(String type) {
        this.type = type;
    }

    public KeyStoreUtil(String type, String provider) {
        this.type = type;
        this.provider = provider;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.type, "type is required.");
        this.keyStore = this.provider == null ? KeyStore.getInstance(this.type) : KeyStore.getInstance(this.type, this.provider);
        this.keyStore.load(this.inputStream, this.password);
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.password != null) {
            CryptoUtils.clear(this.password);
        }
        CryptoUtils.tryDestroy(this.protectionParameter);
    }

    public KeyStore getKeyStore() {
        this.initialize();
        return this.keyStore;
    }

    public SecretKey getSecretKey(String alias) throws CryptoException {
        this.initialize();
        try {
            return (SecretKey)((Object)this.keyStore.getEntry(alias, this.getProtectionParameter()));
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    public KeyStoreUtil setSecretKey(String alias, SecretKey key) throws CryptoException {
        this.initialize();
        try {
            this.keyStore.setEntry(alias, new KeyStore.SecretKeyEntry(key), this.getProtectionParameter());
            return this;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    public KeyStoreUtil setSecretKey(String alias, byte[] key, String algorithm) throws CryptoException {
        this.initialize();
        try {
            this.keyStore.setEntry(alias, new KeyStore.SecretKeyEntry(new SecretKeySpec(key, algorithm)), this.getProtectionParameter());
            return this;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    public KeyStoreUtil setType(String type) {
        this.assertNotInitialized();
        this.type = StringUtils.trimToNull(type);
        return this;
    }

    public KeyStoreUtil setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = StringUtils.trimToNull(provider);
        return this;
    }

    public KeyStoreUtil setPassword(char[] password) {
        this.assertNotInitialized();
        if (password != null) {
            this.password = Arrays.copyOf(password, password.length);
        }
        return this;
    }

    public KeyStoreUtil setInputStream(InputStream inputStream) {
        this.assertNotInitialized();
        this.inputStream = inputStream;
        return this;
    }

    public KeyStoreUtil setProtectionParameter(KeyStore.ProtectionParameter protectionParameter) {
        this.assertNotInitialized();
        this.protectionParameter = protectionParameter;
        return this;
    }

    public KeyStoreUtil setProtectionParameter(char[] password) {
        this.assertNotInitialized();
        if (password != null) {
            this.protectionParameter = new KeyStore.PasswordProtection(password);
        }
        return this;
    }

    protected KeyStore.ProtectionParameter getProtectionParameter() {
        return AssertUtils.assertNotNull(this.protectionParameter, "protectionParameter is required.");
    }
}

