/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.cdi;

import com.appslandia.common.base.Deploy;
import com.appslandia.common.base.DeployPhase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;

public interface DeployBeanFilter {
    public boolean willDeploy(AnnotatedType<?> var1);

    public static class Impl
    implements DeployBeanFilter {
        final Set<Class<?>> excluded = new HashSet();
        final List<DeployBeanFilter> filters = new ArrayList<DeployBeanFilter>();

        public Impl addFilter(DeployBeanFilter filter) {
            this.filters.add(filter);
            return this;
        }

        public Impl exclude(Class<?> beanClass) {
            this.excluded.add(beanClass);
            return this;
        }

        @Override
        public boolean willDeploy(AnnotatedType<?> at) {
            if (this.excluded.contains(at.getJavaClass())) {
                return false;
            }
            for (DeployBeanFilter filter : this.filters) {
                if (filter.willDeploy(at)) continue;
                return false;
            }
            Deploy deploy = (Deploy)at.getAnnotation(Deploy.class);
            if (deploy != null) {
                return DeployPhase.getCurrent().isAny(deploy.value());
            }
            return true;
        }
    }
}

