/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.cdi;

import com.appslandia.common.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;

public class BeanManagerUtils {
    public static <T> T getReference(BeanManager beanManager, Class<? extends T> type) {
        return BeanManagerUtils.getReference(beanManager, type, ReflectionUtils.EMPTY_ANNOTATIONS);
    }

    public static <T> T getReference(BeanManager beanManager, Class<? extends T> type, Annotation ... qualifiers) {
        Bean bean = beanManager.resolve(beanManager.getBeans(type, qualifiers));
        if (bean == null) {
            return null;
        }
        return (T)beanManager.getReference(bean, type, beanManager.createCreationalContext((Contextual)bean));
    }

    public static <T> T getReference(BeanManager beanManager, String name) {
        Bean bean = beanManager.resolve(beanManager.getBeans(name));
        if (bean == null) {
            return null;
        }
        return (T)beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext((Contextual)bean));
    }

    public static CreationalContext<Object> inject(BeanManager beanManager, Object unmanaged) {
        if (unmanaged == null) {
            return null;
        }
        CreationalContext cc = beanManager.createCreationalContext(null);
        InjectionTarget it = beanManager.createInjectionTarget(beanManager.createAnnotatedType(unmanaged.getClass()));
        it.inject(unmanaged, cc);
        return cc;
    }
}

