/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.Permutation;
import com.appslandia.common.base.TextGenerator;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharUtils;
import com.appslandia.common.utils.RandomUtils;
import com.appslandia.common.utils.ValueUtils;
import java.security.SecureRandom;
import java.util.Random;

public class WordsGenerator
extends InitializeObject
implements TextGenerator {
    private static final char[] UPPER_CASES = CharUtils.toCharRange("A-Z");
    private static final char[] LOWER_CASES = CharUtils.toCharRange("a-z");
    private static final char[] DIGITS = CharUtils.toCharRange("0-9");
    private int length;
    final Random random = new SecureRandom();
    private Alphabet alphabet;

    @Override
    protected void init() throws Exception {
        AssertUtils.assertTrue(this.length > 0, "length is required.");
        this.alphabet = ValueUtils.defaultIfNotSet(this.alphabet, Alphabet.UPPER_LOWER_DIGIT);
    }

    @Override
    public String generate() {
        this.initialize();
        if (this.alphabet == Alphabet.UPPER_LOWER_DIGIT) {
            return this.generate(UPPER_CASES, LOWER_CASES, DIGITS);
        }
        if (this.alphabet == Alphabet.UPPER_DIGIT) {
            return this.generate(UPPER_CASES, DIGITS);
        }
        return this.generate(LOWER_CASES, DIGITS);
    }

    private String generate(char[] ... sources) {
        int types = sources.length;
        int len = Math.max(this.length, types);
        int[] sourceRdCounts = new int[types];
        int avgChars = len / types;
        for (int i = 0; i < types; ++i) {
            sourceRdCounts[i] = RandomUtils.nextInt(this.random, 1, avgChars);
        }
        char[] rdChars = new char[len];
        int emptyCount = len;
        Permutation perm = new Permutation(types);
        while (perm.hasNext()) {
            int next = perm.next();
            emptyCount = WordsGenerator.randomChars(this.random, sources[next], rdChars, sourceRdCounts[next], emptyCount);
        }
        for (int i = 0; i < len; ++i) {
            if (rdChars[i] != '\u0000') continue;
            char[] src = sources[this.random.nextInt(types)];
            rdChars[i] = src[this.random.nextInt(src.length)];
        }
        return new String(rdChars, 0, this.length);
    }

    public WordsGenerator setLength(int length) {
        this.assertNotInitialized();
        this.length = length;
        return this;
    }

    public WordsGenerator setAlphabet(Alphabet alphabet) {
        this.assertNotInitialized();
        this.alphabet = alphabet;
        return this;
    }

    public static int randomChars(Random random, char[] src, char[] dest, int rdCount, int emptyCount) {
        for (int i = 0; i < rdCount; ++i) {
            int index = WordsGenerator.randomEmptyIndex(random, dest, emptyCount);
            dest[index] = src[random.nextInt(src.length)];
            --emptyCount;
        }
        return emptyCount;
    }

    private static int randomEmptyIndex(Random random, char[] dest, int emptyCount) {
        int rdIndex = random.nextInt(emptyCount);
        int idx = -1;
        for (int i = 0; i < dest.length; ++i) {
            if (dest[i] != '\u0000' || ++idx != rdIndex) continue;
            return i;
        }
        return 0;
    }

    public static enum Alphabet {
        UPPER_LOWER_DIGIT,
        UPPER_DIGIT,
        LOWER_DIGIT;

    }
}

