/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.TextBuilder;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ReflectionUtils;
import com.appslandia.common.utils.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ToStringBuilder {
    private int level;
    private int identTabs;
    private boolean singleLine;

    public ToStringBuilder() {
        this(0);
    }

    public ToStringBuilder(int level) {
        this.setLevel(level);
    }

    public String toString(Object obj) {
        TextBuilder builder = new TextBuilder();
        this.appendtab(builder, this.identTabs);
        if (obj == null) {
            builder.append("null");
            return builder.toString();
        }
        this.toStringObject(obj, 1, builder);
        return builder.toString();
    }

    public String toStringFields(Object obj) {
        TextBuilder builder = new TextBuilder();
        this.appendtab(builder, this.identTabs);
        if (obj == null) {
            builder.append("null");
            return builder.toString();
        }
        this.toStringFields(obj, 1, builder);
        return builder.toString();
    }

    private void toStringObject(Object obj, int level, TextBuilder builder) {
        if (obj == null) {
            builder.append("null");
            return;
        }
        if (obj instanceof Iterable) {
            this.toStringIterator(obj, new IteratorIterator(((Iterable)obj).iterator()), level, builder);
            return;
        }
        if (obj instanceof Iterator) {
            this.toStringIterator(obj, new IteratorIterator((Iterator)obj), level, builder);
            return;
        }
        if (obj instanceof Enumeration) {
            this.toStringIterator(obj, new EnumerationIterator((Enumeration)obj), level, builder);
            return;
        }
        if (obj.getClass().isArray()) {
            this.toStringIterator(obj, new ArrayIterator(obj), level, builder);
            return;
        }
        if (obj instanceof Map) {
            this.toStringMap((Map)obj, level, builder);
            return;
        }
        if (obj instanceof CharSequence) {
            CharSequence str = (CharSequence)obj;
            builder.append("\"").append(str).append("\"").append(" (").append(str.length()).append(")");
            return;
        }
        if (obj instanceof Number || obj instanceof Date || obj instanceof Boolean || obj instanceof Character) {
            builder.append(obj);
            return;
        }
        if (obj instanceof File || obj instanceof Locale || obj instanceof Charset) {
            builder.append(obj);
            return;
        }
        if (obj instanceof Type || obj.getClass().isEnum() || obj instanceof URL || obj instanceof URI || obj instanceof Void) {
            builder.append(obj);
            return;
        }
        if (obj instanceof Reader || obj instanceof Writer || obj instanceof InputStream || obj instanceof OutputStream) {
            builder.append(obj.getClass().getName()).append("@").append(Integer.toHexString(obj.hashCode()));
            return;
        }
        if (obj.getClass().getName().startsWith("java.sql.")) {
            builder.append(obj.getClass().getName()).append("@").append(Integer.toHexString(obj.hashCode()));
            return;
        }
        this.toStringFields(obj, level, builder);
    }

    private void toStringFields(Object obj, int level, TextBuilder builder) {
        builder.append(obj.getClass().getName()).append("@").append(Integer.toHexString(obj.hashCode()));
        if (level > this.level) {
            return;
        }
        builder.append("[");
        boolean isFirst = true;
        for (Class<?> searchType = obj.getClass(); searchType != null; searchType = searchType.getSuperclass()) {
            AccessibleObject[] fields = searchType.getDeclaredFields();
            Field[] fieldArray = fields;
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field field = fieldArray[i];
                if (!isFirst) {
                    builder.append(",");
                } else {
                    isFirst = false;
                }
                this.appendln(builder);
                this.appendtab(builder, level + this.identTabs);
                if (!Modifier.isStatic(field.getModifiers())) {
                    builder.append(field.getName()).append(": ");
                } else {
                    builder.append("static ").append(field.getName()).append(": ");
                }
                try {
                    field.setAccessible(true);
                    Object fieldValue = field.get(obj);
                    if (fieldValue == null) {
                        builder.append("null");
                        continue;
                    }
                    if (field.getAnnotation(ClassOnly.class) == null) {
                        this.toStringObject(fieldValue, level + 1, builder);
                        continue;
                    }
                    builder.append(fieldValue.getClass().getName()).append("@").append(Integer.toHexString(fieldValue.hashCode()));
                    continue;
                }
                catch (Throwable ex) {
                    builder.append("Exception: ").append(ex);
                }
            }
        }
        try {
            for (AccessibleObject accessibleObject : obj.getClass().getMethods()) {
                Field field;
                String fieldName;
                if (((Method)accessibleObject).getName().equals("getClass") || (fieldName = ToStringBuilder.parseField((Method)accessibleObject)) == null || (field = ReflectionUtils.findField(obj.getClass(), fieldName)) != null) continue;
                if (!isFirst) {
                    builder.append(",");
                } else {
                    isFirst = false;
                }
                this.appendln(builder);
                this.appendtab(builder, level + this.identTabs);
                builder.append(((Method)accessibleObject).getName()).append("(): ");
                try {
                    Object getObj = ((Method)accessibleObject).invoke(obj, new Object[0]);
                    if (getObj == null) {
                        builder.append("null");
                        continue;
                    }
                    if (((Method)accessibleObject).getAnnotation(ClassOnly.class) == null) {
                        this.toStringObject(getObj, level + 1, builder);
                        continue;
                    }
                    builder.append(getObj.getClass().getName()).append("@").append(Integer.toHexString(getObj.hashCode()));
                }
                catch (Throwable ex) {
                    builder.append("Exception: ").append(ex);
                }
            }
        }
        catch (Throwable ex) {
            builder.append("Exception: ").append(ex);
        }
        if (isFirst) {
            builder.append(" no fields/getters ]");
        } else {
            this.appendln(builder);
            this.appendtab(builder, level - 1 + this.identTabs).append("]");
        }
    }

    private void toStringIterator(Object obj, ElementIterator iterator, int level, TextBuilder builder) {
        builder.append(obj.getClass().getName()).append("@").append(Integer.toHexString(obj.hashCode()));
        if (level > this.level) {
            return;
        }
        builder.append("[");
        boolean isFirst = true;
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (!isFirst) {
                builder.append(",");
            } else {
                isFirst = false;
            }
            this.appendln(builder);
            this.appendtab(builder, level + this.identTabs);
            this.toStringObject(element, level + 1, builder);
        }
        if (isFirst) {
            builder.append(" no elements ]");
        } else {
            this.appendln(builder);
            this.appendtab(builder, level - 1 + this.identTabs).append("] (").append(iterator.getIndex()).append(")");
        }
    }

    private void toStringMap(Map<?, ?> map, int level, TextBuilder builder) {
        builder.append(map.getClass().getName()).append("@").append(Integer.toHexString(map.hashCode()));
        if (level > this.level) {
            return;
        }
        builder.append("[");
        boolean isFirst = true;
        for (Object key : map.keySet()) {
            if (!isFirst) {
                builder.append(",");
            } else {
                isFirst = false;
            }
            this.appendln(builder);
            this.appendtab(builder, level + this.identTabs);
            builder.append(key).append(": ");
            this.toStringObject(map.get(key), level + 1, builder);
        }
        if (isFirst) {
            builder.append(" no entries ]");
        } else {
            this.appendln(builder);
            this.appendtab(builder, level - 1 + this.identTabs).append("] (").append(map.size()).append(")");
        }
    }

    private void toStringAttributes(Object obj, Method getAttributeMethod, Set<String> attributes, int level, TextBuilder builder) {
        builder.append("[");
        boolean isFirst = true;
        for (String attribute : attributes) {
            if (!isFirst) {
                builder.append(",");
            } else {
                isFirst = false;
            }
            this.appendln(builder);
            this.appendtab(builder, level + this.identTabs);
            builder.append(attribute).append(": ");
            try {
                Object value = getAttributeMethod.invoke(obj, attribute);
                this.toStringObject(value, level + 1, builder);
            }
            catch (Throwable ex) {
                builder.append("Exception: ").append(ex);
            }
        }
        if (isFirst) {
            builder.append(" no elements ]");
        } else {
            this.appendln(builder);
            this.appendtab(builder, level - 1 + this.identTabs).append("]");
        }
    }

    public String toStringAttributes(Object obj) {
        TextBuilder builder = new TextBuilder();
        this.appendtab(builder, this.identTabs);
        if (obj == null) {
            builder.append("null");
            return builder.toString();
        }
        try {
            Set<String> attributes = ToStringBuilder.getAttributeNames(obj, "getAttributeNames");
            Method method = ReflectionUtils.findMethod(obj.getClass(), "getAttribute");
            AssertUtils.assertNotNull(method);
            builder.append(obj.getClass().getName()).append("@").append(Integer.toHexString(obj.hashCode())).append("-attributes");
            this.toStringAttributes(obj, method, attributes, 1, builder);
        }
        catch (Throwable ex) {
            builder.append("Exception: " + ex);
        }
        return builder.toString();
    }

    public String toStringHeaders(Object obj) {
        TextBuilder builder = new TextBuilder();
        this.appendtab(builder, this.identTabs);
        if (obj == null) {
            builder.append("null");
            return builder.toString();
        }
        try {
            Set<String> attributes = ToStringBuilder.getAttributeNames(obj, "getHeaderNames");
            Method method = ReflectionUtils.findMethod(obj.getClass(), "getHeaders");
            AssertUtils.assertNotNull(method);
            builder.append(obj.getClass().getName()).append("@").append(Integer.toHexString(obj.hashCode())).append("-headers");
            this.toStringAttributes(obj, method, attributes, 1, builder);
        }
        catch (Throwable ex) {
            builder.append("Exception: " + ex);
        }
        return builder.toString();
    }

    private static Set<String> getAttributeNames(Object obj, String methodName) throws Exception {
        Method method = ReflectionUtils.findMethod(obj.getClass(), methodName);
        AssertUtils.assertNotNull(method);
        Object collection = method.invoke(obj, new Object[0]);
        TreeSet<String> names = new TreeSet<String>();
        if (collection instanceof Enumeration) {
            Enumeration enm = (Enumeration)collection;
            while (enm.hasMoreElements()) {
                names.add((String)enm.nextElement());
            }
        } else {
            names.addAll((Collection)collection);
        }
        return names;
    }

    public ToStringBuilder setLevel(int level) {
        this.level = Math.max(level, 2);
        return this;
    }

    public ToStringBuilder setIdentTabs(int identTabs) {
        this.identTabs = Math.max(identTabs, 0);
        return this;
    }

    public ToStringBuilder setSingleLine(boolean singleLine) {
        this.singleLine = singleLine;
        return this;
    }

    private TextBuilder appendln(TextBuilder builder) {
        if (!this.singleLine) {
            builder.appendln();
        }
        return builder;
    }

    private TextBuilder appendtab(TextBuilder builder, int tabs) {
        if (this.singleLine) {
            builder.appendsp();
        } else {
            builder.appendtab(tabs);
        }
        return builder;
    }

    static String parseField(Method pubMth) {
        if (pubMth.getParameterTypes().length > 0) {
            return null;
        }
        if (pubMth.getReturnType() == Void.TYPE) {
            return null;
        }
        if (pubMth.getName().equals("get") || pubMth.getName().equals("is")) {
            return null;
        }
        if (pubMth.getName().startsWith("get")) {
            return StringUtils.firstLowerCase(pubMth.getName().substring(3));
        }
        if (pubMth.getName().startsWith("is")) {
            return StringUtils.firstLowerCase(pubMth.getName().substring(2));
        }
        return null;
    }

    static class EnumerationIterator
    implements ElementIterator {
        final Enumeration<?> obj;
        int index = 0;

        public EnumerationIterator(Enumeration<?> obj) {
            this.obj = obj;
        }

        @Override
        public boolean hasNext() {
            return this.obj.hasMoreElements();
        }

        @Override
        public Object next() {
            ++this.index;
            return this.obj.nextElement();
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }

    static class IteratorIterator
    implements ElementIterator {
        final Iterator<?> obj;
        int index = 0;

        public IteratorIterator(Iterator<?> obj) {
            this.obj = obj;
        }

        @Override
        public boolean hasNext() {
            return this.obj.hasNext();
        }

        @Override
        public Object next() {
            ++this.index;
            return this.obj.next();
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }

    static class ArrayIterator
    implements ElementIterator {
        final Object obj;
        final int len;
        int index = 0;

        public ArrayIterator(Object obj) {
            this.obj = obj;
            this.len = Array.getLength(obj);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.len;
        }

        @Override
        public Object next() {
            return Array.get(this.obj, this.index++);
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }

    static interface ElementIterator {
        public boolean hasNext();

        public Object next();

        public int getIndex();
    }

    @Target(value={ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface ClassOnly {
    }
}

