/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.utils.UncheckedInterruptedException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class ThreadSafeTester {
    final int concurrencies;
    final CountDownLatch countDownLatch;
    final ExecutorService executorService;

    public ThreadSafeTester(int concurrencies) {
        this(concurrencies, 100, true);
    }

    public ThreadSafeTester(int concurrencies, int threadsInPool) {
        this(concurrencies, threadsInPool, true);
    }

    public ThreadSafeTester(int concurrencies, int threadsInPool, boolean awaitAll) {
        this.concurrencies = concurrencies;
        this.executorService = Executors.newFixedThreadPool(threadsInPool);
        this.countDownLatch = awaitAll ? new CountDownLatch(concurrencies) : null;
    }

    protected abstract Runnable newTask();

    public ThreadSafeTester run() {
        for (int i = 0; i < this.concurrencies; ++i) {
            this.executorService.execute(this.newTask());
        }
        return this;
    }

    protected void countDown() {
        if (this.countDownLatch != null) {
            this.countDownLatch.countDown();
        }
    }

    public void await() throws UncheckedInterruptedException {
        if (this.countDownLatch != null) {
            try {
                this.countDownLatch.await();
            }
            catch (InterruptedException ex) {
                throw new UncheckedInterruptedException(ex);
            }
        }
    }

    public void await(long timeout, TimeUnit unit) throws UncheckedInterruptedException {
        if (this.countDownLatch != null) {
            try {
                this.countDownLatch.await(timeout, unit);
            }
            catch (InterruptedException ex) {
                throw new UncheckedInterruptedException(ex);
            }
        }
    }
}

