/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.PropertyBase;
import com.appslandia.common.utils.URLEncoding;
import java.util.LinkedHashMap;
import java.util.Map;

public class QueryParams
extends PropertyBase {
    private static final long serialVersionUID = 1L;

    public QueryParams() {
        super(new LinkedHashMap<String, String>());
    }

    public QueryParams(Map<String, String> newMap) {
        super(newMap);
    }

    public QueryParams parse(String queryString) {
        int endIdx;
        int startIdx = 0;
        while ((endIdx = queryString.indexOf(38, startIdx)) != -1) {
            this.parseNameVal(queryString.substring(startIdx, endIdx));
            startIdx = endIdx + 1;
        }
        if (startIdx < queryString.length()) {
            this.parseNameVal(queryString.substring(startIdx));
        }
        return this;
    }

    private void parseNameVal(String nameVal) {
        int idx = nameVal.indexOf(61);
        if (idx <= 0) {
            return;
        }
        String name = nameVal.substring(0, idx).trim();
        if (name.isEmpty()) {
            return;
        }
        String value = nameVal.substring(idx + 1).trim();
        if (value.isEmpty()) {
            this.props.put(name, null);
        } else {
            this.props.put(name, URLEncoding.decode(value));
        }
    }

    public String toString() {
        if (this.props.isEmpty()) {
            return null;
        }
        return this.toBuilder().toString();
    }

    public StringBuilder toBuilder() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.props.entrySet()) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append((String)entry.getKey()).append('=');
            if (entry.getValue() == null) continue;
            sb.append(URLEncoding.encode((String)entry.getValue()));
        }
        return sb;
    }
}

