/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.PropertyBase;
import com.appslandia.common.base.StringWriter;
import com.appslandia.common.utils.CharsetUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertyMap
extends PropertyBase {
    private static final long serialVersionUID = 1L;

    public PropertyMap() {
        super(new LinkedHashMap<String, String>());
    }

    public PropertyMap(Map<String, String> newMap) {
        super(newMap);
    }

    public void load(InputStream inStream) throws IOException {
        LinkedProperties props = new LinkedProperties();
        props.load(inStream);
        this.fromProperties(props);
    }

    public void load(Reader reader) throws IOException {
        LinkedProperties props = new LinkedProperties();
        props.load(reader);
        this.fromProperties(props);
    }

    public void load(File file) throws IOException {
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CharsetUtils.UTF_8));
            this.load(br);
        }
    }

    public void load(String file) throws IOException {
        this.load(new File(file));
    }

    protected void fromProperties(Properties props) {
        for (Object ky : props.keySet()) {
            String key = (String)ky;
            String value = (String)props.get(key);
            if (key.isEmpty()) continue;
            this.props.put(key, !value.isEmpty() ? value : null);
        }
    }

    public void store(File file, String comments) throws IOException {
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), CharsetUtils.UTF_8));){
            this.store(w, comments);
        }
    }

    public void store(String file, String comments) throws IOException {
        this.store(new File(file), comments);
    }

    public void store(OutputStream os, String comments) throws IOException {
        this.toProperties().store(os, comments);
    }

    public void store(Writer w, String comments) throws IOException {
        this.toProperties().store(w, comments);
    }

    protected Properties toProperties() {
        LinkedProperties props = new LinkedProperties();
        for (Map.Entry prop : this.props.entrySet()) {
            ((Properties)props).put(prop.getKey(), prop.getValue() != null ? prop.getValue() : "");
        }
        return props;
    }

    public String toString() {
        try {
            StringWriter out = new StringWriter();
            this.store(out, this.getClass().getName());
            return out.toString();
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static class LinkedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        final Set<Object> keys = new LinkedHashSet<Object>();

        private LinkedProperties() {
        }

        @Override
        public Set<Object> keySet() {
            return this.keys;
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(this.keys);
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            this.keys.add(key);
            return super.put(key, value);
        }
    }
}

