/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.InitializeException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.StringUtils;
import java.util.Locale;

public class Language
extends InitializeObject {
    public static final String FORMAT_TIME_24H = "HH:mm";
    public static final String FORMAT_TIME_24H_Z = "HH:mmXXX";
    public static final String FORMAT_TIME = "HH:mm:ss.SSS";
    public static final String FORMAT_TIME_Z = "HH:mm:ss.SSSXXX";
    public static final Language EN = (Language)new Language().setLocale(Locale.US).setDateFormat("MM/dd/yyyy").initialize();
    public static final Language VI = (Language)new Language().setLocale(new Locale("vi", "VN")).setDateFormat("dd/MM/yyyy").initialize();
    private Locale locale;
    private String dateFormat;
    private String dateTimeFormat;
    private String dateTimeZFormat;
    private String dateTime24HFormat;
    private String dateTime24HZFormat;
    private static volatile Language current;
    private static final Object MUTEX;
    public static final String SYSTEM_PROP_LANGUAGE = "__language";

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.locale, "locale is required.");
        AssertUtils.assertNotNull(this.dateFormat, "dateFormat is required.");
        this.dateTimeFormat = String.format("%s %s", this.dateFormat, FORMAT_TIME);
        this.dateTimeZFormat = String.format("%s %s", this.dateFormat, FORMAT_TIME_Z);
        this.dateTime24HFormat = String.format("%s %s", this.dateFormat, FORMAT_TIME_24H);
        this.dateTime24HZFormat = String.format("%s %s", this.dateFormat, FORMAT_TIME_24H_Z);
    }

    public String getId() {
        this.initialize();
        return this.locale.getLanguage();
    }

    public String getDisplayLanguage() {
        this.initialize();
        return this.locale.getDisplayLanguage(this.locale);
    }

    public Locale getLocale() {
        this.initialize();
        return this.locale;
    }

    public Language setLocale(Locale locale) {
        this.assertNotInitialized();
        this.locale = locale;
        return this;
    }

    public String getDateFormat() {
        this.initialize();
        return this.dateFormat;
    }

    public Language setDateFormat(String dateFormat) {
        this.assertNotInitialized();
        this.dateFormat = StringUtils.trimToNull(dateFormat);
        return this;
    }

    public String getDateTimeFormat() {
        this.initialize();
        return this.dateTimeFormat;
    }

    public String getDateTimeZFormat() {
        this.initialize();
        return this.dateTimeZFormat;
    }

    public String getDateTime24HFormat() {
        this.initialize();
        return this.dateTime24HFormat;
    }

    public String getDateTime24HZFormat() {
        this.initialize();
        return this.dateTime24HZFormat;
    }

    public String getTime24HFormat() {
        this.initialize();
        return FORMAT_TIME_24H;
    }

    public String getTime24HZFormat() {
        this.initialize();
        return FORMAT_TIME_24H_Z;
    }

    public String getTimeFormat() {
        this.initialize();
        return FORMAT_TIME;
    }

    public String getTimeZFormat() {
        this.initialize();
        return FORMAT_TIME_Z;
    }

    public int hashCode() {
        return ObjectUtils.hashCode(this.getId().toLowerCase(Locale.ENGLISH));
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Language)) {
            return false;
        }
        Language another = (Language)obj;
        return this.getId().equalsIgnoreCase(another.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Language getCurrent() {
        Language obj = current;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = current;
                if (obj == null) {
                    current = obj = Language.initLanguage();
                }
            }
        }
        return obj;
    }

    public static void setCurrent(Language obj) {
        AssertUtils.assertNull(current);
        current = obj;
    }

    private static Language initLanguage() {
        try {
            String implName = System.getProperty(SYSTEM_PROP_LANGUAGE);
            if (implName == null) {
                return EN;
            }
            Class<?> implClass = null;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl != null) {
                    implClass = cl.loadClass(implName);
                }
            }
            catch (ClassNotFoundException cl) {
                // empty catch block
            }
            if (implClass == null) {
                try {
                    implClass = Language.class.getClassLoader().loadClass(implName);
                }
                catch (ClassNotFoundException cl) {
                    // empty catch block
                }
            }
            Object impl = implClass.newInstance();
            return (Language)Language.class.cast(impl);
        }
        catch (Exception ex) {
            throw new InitializeException(ex);
        }
    }

    static {
        MUTEX = new Object();
    }
}

