/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.base.Language;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;

public class FormatProviderImpl
implements FormatProvider {
    protected final Language language;
    protected DateFormatCache dateFormatCache;
    protected NumberFormat integerFormat;
    protected NumberFormat numberFormat;
    protected NumberFormat bigDecimalFormat;

    public FormatProviderImpl() {
        this(Language.getCurrent());
    }

    public FormatProviderImpl(Language language) {
        this.language = language;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public NumberFormat getIntegerFormat() {
        if (this.integerFormat == null) {
            this.integerFormat = NumberFormat.getIntegerInstance(this.language.getLocale());
        }
        return this.integerFormat;
    }

    @Override
    public NumberFormat getNumberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getNumberInstance(this.language.getLocale());
        }
        return this.numberFormat;
    }

    @Override
    public NumberFormat getBigDecimalFormat() {
        if (this.bigDecimalFormat == null) {
            NumberFormat format = NumberFormat.getNumberInstance(this.language.getLocale());
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setParseBigDecimal(true);
            }
            this.bigDecimalFormat = format;
        }
        return this.bigDecimalFormat;
    }

    @Override
    public DateFormat getDateFormat() {
        return this.getDateFormatCache().get(this.language.getDateFormat());
    }

    @Override
    public DateFormat getTimeFormat() {
        return this.getDateFormatCache().get(this.language.getTimeFormat());
    }

    @Override
    public DateFormat getDateTimeFormat() {
        return this.getDateFormatCache().get(this.language.getDateTimeFormat());
    }

    @Override
    public DateFormat getTime24Format() {
        return this.getDateFormatCache().get(this.language.getTime24HFormat());
    }

    @Override
    public DateFormat getDateTime24Format() {
        return this.getDateFormatCache().get(this.language.getDateTime24HFormat());
    }

    protected DateFormatCache getDateFormatCache() {
        if (this.dateFormatCache == null) {
            this.dateFormatCache = new DateFormatCache(7);
        }
        return this.dateFormatCache;
    }

    static class DateFormatCache
    extends HashMap<String, SimpleDateFormat> {
        private static final long serialVersionUID = 1L;

        public DateFormatCache(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public SimpleDateFormat get(Object pattern) {
            SimpleDateFormat format = (SimpleDateFormat)super.get(pattern);
            if (format == null) {
                format = new SimpleDateFormat((String)pattern);
                format.setLenient(false);
                this.put((String)pattern, format);
            }
            return format;
        }
    }
}

