/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.InitializeException;
import com.appslandia.common.utils.AssertUtils;

public class Base64 {
    private static volatile Delegate delegate;
    private static final Object MUTEX;

    private Base64() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Delegate getDelegate() {
        Delegate obj = delegate;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = delegate;
                if (obj == null) {
                    delegate = obj = Base64.initJdk8Delegate();
                }
            }
        }
        AssertUtils.assertNotNull(obj, "Base64.delegate is required.");
        return obj;
    }

    private static Delegate initJdk8Delegate() {
        try {
            Class<?> implClass = null;
            String jdk8Impl = "com.appslandia.common.base.Jdk8Base64Delegate";
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl != null) {
                    implClass = cl.loadClass("com.appslandia.common.base.Jdk8Base64Delegate");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (implClass == null) {
                try {
                    implClass = Base64.class.getClassLoader().loadClass("com.appslandia.common.base.Jdk8Base64Delegate");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (implClass != null) {
                return (Delegate)Delegate.class.cast(implClass.newInstance());
            }
            return null;
        }
        catch (Exception ex) {
            throw new InitializeException(ex);
        }
    }

    public static void setDelegate(Delegate obj) {
        AssertUtils.assertNull(delegate);
        delegate = obj;
    }

    static {
        MUTEX = new Object();
    }

    public static interface Delegate {
        public byte[] encode(byte[] var1);

        public byte[] decode(byte[] var1);

        public byte[] urlEncode(byte[] var1);

        public byte[] urlDecode(byte[] var1);

        public byte[] mimeEncode(byte[] var1);

        public byte[] mimeDecode(byte[] var1);
    }
}

