/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.BOM;
import java.io.IOException;
import java.io.OutputStream;

public class BOMOutputStream
extends OutputStream {
    final OutputStream os;
    final BOM bom;

    public BOMOutputStream(OutputStream os, String encoding) throws IOException {
        this(os, BOM.parse(encoding));
    }

    public BOMOutputStream(OutputStream os, BOM bom) throws IOException {
        this.os = os;
        this.bom = bom;
        if (this.bom != null) {
            this.os.write(this.bom.getBytes());
        }
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public BOM getBOM() {
        return this.bom;
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

