/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.BOM;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class BOMInputStream
extends InputStream {
    private PushbackInputStream in;
    private BOM bom;
    private boolean skipped;

    public BOMInputStream(InputStream is) throws IOException {
        if (is == null) {
            throw new NullPointerException();
        }
        this.in = new PushbackInputStream(is, 4);
        byte[] fourBytes = new byte[4];
        int count = this.in.read(fourBytes);
        switch (count) {
            case 3: {
                if (BOM.UTF_8.compare(fourBytes, count)) {
                    this.bom = BOM.UTF_8;
                    break;
                }
            }
            case 2: {
                if (BOM.UTF_16BE.compare(fourBytes, count)) {
                    this.bom = BOM.UTF_16BE;
                    break;
                }
                if (BOM.UTF_16LE.compare(fourBytes, count)) {
                    this.bom = BOM.UTF_16LE;
                    break;
                }
            }
            case 4: {
                if (BOM.UTF_32BE.compare(fourBytes, count)) {
                    this.bom = BOM.UTF_32BE;
                    break;
                }
                if (!BOM.UTF_32LE.compare(fourBytes, count)) break;
                this.bom = BOM.UTF_32LE;
                break;
            }
        }
        if (count > 0) {
            this.in.unread(fourBytes, 0, count);
        }
    }

    public BOM getBOM() {
        return this.bom;
    }

    public synchronized BOMInputStream skipBOM() throws IOException {
        if (this.bom == null) {
            return this;
        }
        if (!this.skipped) {
            this.in.skip(this.bom.length());
            this.skipped = true;
        }
        return this;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }
}

