/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.oaid;

import android.content.Context;
import androidx.annotation.Nullable;
import com.appsflyer.oaid.OaidClient;
import com.bun.miitmdid.core.MdidSdkHelper;
import com.bun.miitmdid.interfaces.IIdentifierListener;
import com.bun.miitmdid.interfaces.IdSupplier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

class OaidMsaClient {
    private static boolean isCertInit = false;
    private static final String CER_PATTERN = "%s.cert.pem";
    private static final String MAS_NATIVE_LIB = "msaoaidsec";

    OaidMsaClient() {
    }

    @Nullable
    static OaidClient.Info fetchMsa(Context context, final Logger logger, long timeout, TimeUnit unit) {
        try {
            OaidMsaClient.loadNativeLibrary();
            if (!isCertInit) {
                try {
                    isCertInit = MdidSdkHelper.InitCert((Context)context, (String)OaidMsaClient.loadPemFromAssetFile(context, String.format(CER_PATTERN, context.getPackageName()), logger));
                }
                catch (Throwable e) {
                    logger.warning(e.getMessage());
                }
                if (!isCertInit) {
                    logger.warning("getDeviceIds: cert init failed");
                }
            }
            final LinkedBlockingQueue oaidHolder = new LinkedBlockingQueue();
            int result = MdidSdkHelper.InitSdk((Context)context, (logger.getLevel() == null ? 1 : 0) != 0, (IIdentifierListener)new IIdentifierListener(){

                public void onSupport(IdSupplier supplier) {
                    try {
                        if (supplier != null) {
                            oaidHolder.offer(new OaidClient.Info(supplier.getOAID(), supplier.isLimited()));
                        }
                    }
                    catch (Throwable t) {
                        logger.info(t.getMessage());
                    }
                }
            });
            if (result != 0) {
                String error;
                switch (result) {
                    case 1008612: {
                        error = "Unsupported device";
                        break;
                    }
                    case 1008613: {
                        error = "Error loading configuration file";
                        break;
                    }
                    case 1008611: {
                        error = "Unsupported manufacturer";
                        break;
                    }
                    case 1008614: {
                        error = "Callback will be executed in a different thread";
                        break;
                    }
                    case 1008615: {
                        error = "Reflection call error";
                        break;
                    }
                    case 1008610: {
                        error = "result ok (sync)";
                        break;
                    }
                    case 1008616: {
                        error = "cert not init or check not pass";
                        break;
                    }
                    default: {
                        error = String.valueOf(result);
                    }
                }
                logger.warning(error);
            }
            return (OaidClient.Info)oaidHolder.poll(timeout, unit);
        }
        catch (Throwable t) {
            logger.info(t.getMessage());
            t.printStackTrace();
            return null;
        }
    }

    protected static void loadNativeLibrary() {
        System.loadLibrary(MAS_NATIVE_LIB);
    }

    private static String loadPemFromAssetFile(Context context, String assetFileName, Logger logger) {
        try {
            String line;
            InputStream is = context.getAssets().open(assetFileName);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder();
            while ((line = in.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
            return builder.toString();
        }
        catch (IOException e) {
            logger.warning("loadPemFromAssetFile failed");
            return "";
        }
    }
}

