/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import com.appsflyer.AndroidUtils;
import com.appsflyer.AppsFlyerLibCore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class EventDataCollector {
    private final Application values;
    private final SharedPreferences AFDateFormat;

    public EventDataCollector(Context context) {
        this.values = (Application)context.getApplicationContext();
        this.AFDateFormat = AppsFlyerLibCore.getSharedPreferences((Context)this.values);
    }

    public String signature() throws CertificateException, NoSuchAlgorithmException, PackageManager.NameNotFoundException {
        return AndroidUtils.signature(this.values.getPackageManager(), this.values.getPackageName());
    }

    public long bootTime() {
        return System.currentTimeMillis() - SystemClock.elapsedRealtime();
    }

    public String disk() {
        long l2;
        long l3;
        StatFs statFs = new StatFs(Environment.getDataDirectory().getAbsolutePath());
        if (Build.VERSION.SDK_INT >= 18) {
            long l4 = statFs.getBlockSizeLong();
            l3 = statFs.getAvailableBlocksLong() * l4;
            l2 = statFs.getBlockCountLong() * l4;
        } else {
            int n = statFs.getBlockSize();
            l3 = statFs.getAvailableBlocks() * n;
            l2 = statFs.getBlockCount() * n;
        }
        double d2 = Math.pow(2.0, 20.0);
        l3 = (long)((double)l3 / d2);
        l2 = (long)((double)l2 / d2);
        return l3 + "/" + l2;
    }

    public long getLong(String string) {
        return this.AFDateFormat.getLong(string, 0L);
    }

    @Nullable
    public String getString(String string) {
        return this.AFDateFormat.getString(string, null);
    }

    public void set(String string, long l2) {
        this.AFDateFormat.edit().putLong(string, l2).apply();
    }

    public void set(String string, String string2) {
        this.AFDateFormat.edit().putString(string, string2).apply();
    }

    public void init() {
        if (this.$$b()) {
            this.set("init_ts", System.currentTimeMillis());
        }
    }

    public void foreground() {
        if (this.$$b()) {
            this.set("fg_ts", System.currentTimeMillis());
        }
    }

    private boolean $$b() {
        return AppsFlyerLibCore.getInstance().getLaunchCounter(this.AFDateFormat, false) == 0;
    }
}

