/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFh1dSDK;
import com.appsflyer.internal.AFi1zSDK;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFi1vSDK {
    private final boolean getCurrencyIso4217Code;
    @NonNull
    public final String AFAdRevenueData;
    @NonNull
    public final String getMediationNetwork;
    @NonNull
    public final AFh1dSDK getRevenue;
    @Nullable
    public final AFi1zSDK getMonetizationNetwork;

    public AFi1vSDK(@NonNull String object) throws JSONException {
        if (object == null) {
            throw new JSONException("Failed to parse remote configuration JSON: originalJson is null");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            this.AFAdRevenueData = jSONObject.getString("ver");
            this.getCurrencyIso4217Code = jSONObject.optBoolean("test_mode");
            this.getMediationNetwork = object;
            this.getRevenue = this.AFAdRevenueData.startsWith("default") ? AFh1dSDK.getCurrencyIso4217Code : AFh1dSDK.getMonetizationNetwork;
            object = null;
            jSONObject = jSONObject.optJSONObject("features");
            if (jSONObject != null) {
                object = new AFi1zSDK(jSONObject);
            }
            this.getMonetizationNetwork = object;
            return;
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("Error in RC config parsing", jSONException);
            throw new JSONException("Failed to parse remote configuration JSON");
        }
    }

    public final boolean equals(Object o) {
        AFi1vSDK aFi1vSDK;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        aFi1vSDK = aFi1vSDK;
        if (this.getCurrencyIso4217Code != aFi1vSDK.getCurrencyIso4217Code) {
            return false;
        }
        if (!this.AFAdRevenueData.equals(aFi1vSDK.AFAdRevenueData)) {
            return false;
        }
        return this.getMediationNetwork.equals(aFi1vSDK.getMediationNetwork);
    }

    public final int hashCode() {
        int n = this.getCurrencyIso4217Code ? 1 : 0;
        n = n * 31 + this.AFAdRevenueData.hashCode();
        n = n * 31 + this.getMediationNetwork.hashCode();
        if (this.getMonetizationNetwork != null) {
            n = n * 31 + ((Object)this.getMonetizationNetwork).hashCode();
        }
        return n;
    }
}

