/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1mSDK;
import com.appsflyer.internal.AFc1kSDK;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;

public final class AFj1dSDK {
    public static String AFAdRevenueData(String string) {
        String string2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string.getBytes(Charset.defaultCharset()));
            string2 = AFj1dSDK.getRevenue(messageDigest.digest());
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Error turning data to SHA-256 string", exception);
        }
        return string2;
    }

    private static String getRevenue(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(Integer.toString((by & 0xFF) + 256, 16).substring(1));
        }
        return ((Object)stringBuilder).toString();
    }

    @Nullable
    public static byte[] getRevenue(@NonNull String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string.getBytes(Charset.defaultCharset()));
            return messageDigest.digest();
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Error turning string to SHA-256 byte array", exception);
            return null;
        }
    }

    public static long getCurrencyIso4217Code(@Nullable byte[] byArray) {
        long l = -1L;
        if (byArray != null && byArray.length > 0) {
            if (byArray.length > 8) {
                byArray = Arrays.copyOfRange(byArray, 0, 8);
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            byteBuffer.put(byArray);
            byteBuffer.flip();
            l = byteBuffer.getLong();
        }
        return l;
    }

    public static String getRevenue(String string, String string2) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(string2.getBytes(Charset.defaultCharset()), "HmacSHA256"));
            return AFj1dSDK.getRevenue(mac.doFinal(string.getBytes(Charset.defaultCharset()))).toLowerCase(Locale.getDefault());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            GeneralSecurityException generalSecurityException2 = generalSecurityException;
            AFLogger.afErrorLog(generalSecurityException.getMessage(), generalSecurityException2, true);
            return generalSecurityException2.getMessage();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean getRevenue(Map<String, Object> map, String[] object, AFc1kSDK aFc1kSDK) throws IllegalStateException {
        void var2_3;
        Object object22;
        if (map == null || map.isEmpty()) {
            return false;
        }
        for (Object object22 : object) {
            if (map.containsKey(object22)) continue;
            return false;
        }
        String string = (String)map.remove("sig");
        if (string == null) {
            return false;
        }
        String string2 = AFc1kSDK.component2();
        String string3 = new JSONObject(map) + string2;
        object22 = AFb1mSDK.getRevenue(var2_3.getRevenue);
        return AFj1dSDK.getRevenue(string3, (String)object22).equals(string);
    }
}

