/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFh1dSDK;
import com.appsflyer.internal.AFi1zSDK;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFi1ySDK {
    private final boolean AFAdRevenueData;
    @NonNull
    public final String getCurrencyIso4217Code;
    @NonNull
    public final String getMediationNetwork;
    @NonNull
    public final AFh1dSDK getMonetizationNetwork;
    @Nullable
    public final AFi1zSDK getRevenue;

    public AFi1ySDK(@NonNull String object) throws JSONException {
        if (object == null) {
            throw new JSONException("Failed to parse remote configuration JSON: originalJson is null");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            this.getCurrencyIso4217Code = jSONObject.getString("ver");
            this.AFAdRevenueData = jSONObject.optBoolean("test_mode");
            this.getMediationNetwork = object;
            this.getMonetizationNetwork = this.getCurrencyIso4217Code.startsWith("default") ? AFh1dSDK.getMediationNetwork : AFh1dSDK.getRevenue;
            object = null;
            jSONObject = jSONObject.optJSONObject("features");
            if (jSONObject != null) {
                object = new AFi1zSDK(jSONObject);
            }
            this.getRevenue = object;
            return;
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("Error in RC config parsing", jSONException);
            throw new JSONException("Failed to parse remote configuration JSON");
        }
    }

    public final boolean equals(Object o) {
        AFi1ySDK aFi1ySDK;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        aFi1ySDK = aFi1ySDK;
        if (this.AFAdRevenueData != aFi1ySDK.AFAdRevenueData) {
            return false;
        }
        if (!this.getCurrencyIso4217Code.equals(aFi1ySDK.getCurrencyIso4217Code)) {
            return false;
        }
        return this.getMediationNetwork.equals(aFi1ySDK.getMediationNetwork);
    }

    public final int hashCode() {
        int n = this.AFAdRevenueData ? 1 : 0;
        n = n * 31 + this.getCurrencyIso4217Code.hashCode();
        n = n * 31 + this.getMediationNetwork.hashCode();
        if (this.getRevenue != null) {
            n = n * 31 + ((Object)this.getRevenue).hashCode();
        }
        return n;
    }
}

