/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import com.appsflyer.internal.AFh1bSDK;
import com.appsflyer.internal.AFh1dSDK;
import com.appsflyer.internal.AFi1xSDK;
import java.util.ArrayList;
import java.util.List;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFh1cSDK {
    @Nullable
    public final AFh1dSDK getMonetizationNetwork;
    @Nullable
    public final AFh1bSDK getRevenue;
    @Nullable
    public AFi1xSDK getMediationNetwork;

    public AFh1cSDK(@NotNull JSONObject jSONObject) {
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"");
        this.getMediationNetwork = AFh1cSDK.getMonetizationNetwork(jSONObject);
        this.getMonetizationNetwork = AFh1cSDK.getRevenue(jSONObject);
        this.getRevenue = AFh1cSDK.getCurrencyIso4217Code(jSONObject);
    }

    private static AFh1bSDK getCurrencyIso4217Code(JSONObject object) {
        try {
            AFh1bSDK aFh1bSDK;
            JSONObject jSONObject = AFh1cSDK.getMonetizationNetwork((JSONObject)object, "meta_data");
            if (jSONObject != null) {
                double d = jSONObject.optDouble("send_rate", 1.0);
                aFh1bSDK = new AFh1bSDK(d);
            } else {
                aFh1bSDK = null;
            }
            object = Result.constructor-impl(aFh1bSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFh1bSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static AFh1dSDK getRevenue(JSONObject object) {
        try {
            AFh1dSDK aFh1dSDK;
            JSONObject jSONObject = AFh1cSDK.getMonetizationNetwork((JSONObject)object, "exc_mngr");
            if (jSONObject != null) {
                object = jSONObject;
                String string = jSONObject.getString("sdk_ver");
                int n = object.optInt("min", -1);
                int n2 = object.optInt("expire", -1);
                long l = object.optLong("ttl", -1L);
                aFh1dSDK = new AFh1dSDK(string, n, n2, l);
            } else {
                aFh1dSDK = null;
            }
            object = Result.constructor-impl(aFh1dSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFh1dSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static AFi1xSDK getMonetizationNetwork(JSONObject object) {
        try {
            AFi1xSDK aFi1xSDK;
            JSONObject jSONObject = AFh1cSDK.getMonetizationNetwork(object, "r_debugger");
            if (jSONObject != null) {
                List list;
                object = jSONObject;
                long l = jSONObject.getLong("ttl");
                int n = object.getInt("counter");
                String string = object.optString("app_ver", "");
                String string2 = object.optString("sdk_ver", "");
                float f = (float)object.optDouble("ratio", 1.0);
                if ((object = object.optJSONArray("tags")) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
                    List list2 = new ArrayList();
                    int n2 = object.length();
                    for (int i = 0; i < n2; ++i) {
                        String string3 = object.getString(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                        list2.add(string3);
                    }
                    list = list2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                object = list;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                aFi1xSDK = new AFi1xSDK(l, f, (List<String>)object, n, string, string2);
            } else {
                aFi1xSDK = null;
            }
            object = Result.constructor-impl(aFi1xSDK);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (AFi1xSDK)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static JSONObject getMonetizationNetwork(JSONObject jSONObject, String string) throws JSONException, NullPointerException {
        if (jSONObject.has(string)) {
            if ((jSONObject = jSONObject.getJSONArray(string).optJSONObject(0).optJSONObject("data")) != null) {
                return jSONObject.optJSONObject("v1");
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(@Nullable Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"");
        AFh1cSDK cfr_ignored_0 = (AFh1cSDK)other;
        if (!Intrinsics.areEqual((Object)this.getMonetizationNetwork, (Object)((AFh1cSDK)other).getMonetizationNetwork)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getRevenue, (Object)((AFh1cSDK)other).getRevenue)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getMediationNetwork, (Object)((AFh1cSDK)var1_1).getMediationNetwork);
    }

    public final int hashCode() {
        AFh1dSDK aFh1dSDK = this.getMonetizationNetwork;
        int n = aFh1dSDK != null ? ((Object)aFh1dSDK).hashCode() : 0;
        AFh1bSDK aFh1bSDK = this.getRevenue;
        n = n * 31 + (aFh1bSDK != null ? aFh1bSDK.hashCode() : 0);
        AFi1xSDK aFi1xSDK = this.getMediationNetwork;
        return n * 31 + (aFi1xSDK != null ? ((Object)aFi1xSDK).hashCode() : 0);
    }
}

