/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFc1qSDK;
import com.appsflyer.internal.AFd1aSDK;
import com.appsflyer.internal.AFd1iSDK;
import com.appsflyer.internal.AFe1mSDK;
import com.appsflyer.internal.AFe1rSDK;
import com.appsflyer.internal.AFe1sSDK;
import com.appsflyer.internal.AFf1uSDK;
import com.appsflyer.internal.AFg1nSDK;
import java.util.Map;
import org.json.JSONException;

public final class AFg1rSDK
extends AFe1sSDK<Void> {
    private final AFc1qSDK component4;
    @Nullable
    private final AFd1aSDK<String> component3;
    @Nullable
    private final Throwable component1;

    public AFg1rSDK(AFf1uSDK aFf1uSDK, AFc1qSDK aFc1qSDK) {
        super(AFe1mSDK.copy, new AFe1mSDK[]{AFe1mSDK.getCurrencyIso4217Code}, "GCD-CHECK");
        this.component1 = aFf1uSDK.component1();
        this.component3 = aFf1uSDK.component2;
        this.component4 = aFc1qSDK;
    }

    @Override
    @NonNull
    public final AFe1rSDK getRevenue() throws Exception {
        Map<String, Object> map;
        int n = this.component4.AFAdRevenueData("appsFlyerCount", 0);
        AFLogger.afDebugLog("[GCD-A01] Loading conversion data. Counter: ".concat(String.valueOf(n)));
        long l = this.component4.getCurrencyIso4217Code("appsflyerConversionDataCacheExpiration", 0L);
        if (l != 0L && System.currentTimeMillis() - l > 5184000000L) {
            AFLogger.afDebugLog("[GCD-E02] Cached conversion data expired");
            this.component4.AFAdRevenueData("sixtyDayConversionData", true);
            this.component4.getCurrencyIso4217Code("attributionId", null);
            this.component4.getRevenue("appsflyerConversionDataCacheExpiration", 0L);
        }
        if ((map = this.areAllFieldsValid()) != null) {
            try {
                if (!map.containsKey("is_first_launch")) {
                    map.put("is_first_launch", Boolean.FALSE);
                }
                AFg1nSDK.getMediationNetwork(map);
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("[GCD] Error executing conversion data callback: " + exception.getLocalizedMessage(), exception);
            }
            return AFe1rSDK.getRevenue;
        }
        try {
            if (this.component1 != null) {
                AFg1nSDK.getMediationNetwork("Launch exception: " + this.component1.getMessage());
                return AFe1rSDK.getRevenue;
            }
            if (this.component3 != null && !this.component3.isSuccessful()) {
                AFg1nSDK.getMediationNetwork("Launch status code: " + this.component3.getStatusCode());
                return AFe1rSDK.getRevenue;
            }
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("[GCD] Error executing conversion data callback: " + exception.getLocalizedMessage(), exception);
        }
        return AFe1rSDK.getMonetizationNetwork;
    }

    @Override
    public final long getMonetizationNetwork() {
        return 1000L;
    }

    @Override
    public final boolean getCurrencyIso4217Code() {
        return false;
    }

    @Nullable
    private Map<String, Object> areAllFieldsValid() {
        String string = this.component4.getMonetizationNetwork("attributionId", null);
        if (string == null) {
            return null;
        }
        try {
            new AFd1iSDK();
            return AFd1iSDK.getMediationNetwork(string);
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLog("[GCD] Failed to parse GCD response: " + jSONException.getMessage(), jSONException);
            return null;
        }
    }
}

