/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFc1pSDK;
import com.appsflyer.internal.AFg1cSDK;
import com.appsflyer.internal.AFi1dSDK;
import com.appsflyer.internal.AFj1iSDK;
import com.appsflyer.internal.AFj1qSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFi1aSDK
extends AFi1dSDK {
    public final Map<String, Object> getCurrencyIso4217Code = new HashMap<String, Object>();
    @NonNull
    final ExecutorService getMonetizationNetwork;

    public AFi1aSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService, @NonNull AFc1pSDK aFc1pSDK) {
        super("store", "google", aFc1pSDK, runnable);
        this.getMonetizationNetwork = executorService;
    }

    private boolean AFAdRevenueData(@NonNull Context context) {
        if (!this.getRevenue()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFj1iSDK.getMonetizationNetwork(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.INSTANCE.d(AFg1cSDK.copydefault, "Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            AFLogger.INSTANCE.v(AFg1cSDK.copydefault, "Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFg1cSDK.copydefault, "An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.INSTANCE.d(AFg1cSDK.copydefault, "Install referrer is not allowed");
        return false;
    }

    @Override
    public final void getRevenue(Context context) {
        if (!this.AFAdRevenueData(context)) {
            return;
        }
        AFi1aSDK aFi1aSDK = this;
        this.component1 = System.currentTimeMillis();
        aFi1aSDK.component4 = AFj1qSDK.AFa1ySDK.getMonetizationNetwork;
        aFi1aSDK.addObserver(new Observer(aFi1aSDK){
            private /* synthetic */ AFj1qSDK getMediationNetwork;
            {
                this.getMediationNetwork = aFj1qSDK;
            }

            public final void update(Observable o, Object arg) {
                this.getMediationNetwork.getRevenue.run();
            }
        });
        try {
            aFi1aSDK = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.INSTANCE.d(AFg1cSDK.copydefault, "Connecting to Install Referrer Library...");
            aFi1aSDK.startConnection(new InstallReferrerStateListener(){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int responseCode) {
                    AFi1aSDK.this.getMonetizationNetwork.execute(() -> AFi1aSDK.this.getRevenue(this.val$referrerClient, this.val$context, responseCode));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.INSTANCE.d(AFg1cSDK.copydefault, "Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFg1cSDK.copydefault, "referrerClient -> startConnection", throwable);
            return;
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final void getRevenue(InstallReferrerClient installReferrerClient, Context context, int n) {
        this.getCurrencyIso4217Code.put("code", String.valueOf(n));
        String string = "com.android.vending";
        this.AFAdRevenueData.put("api_ver", AFj1iSDK.AFAdRevenueData(context, string));
        this.AFAdRevenueData.put("api_ver_name", AFj1iSDK.getMediationNetwork(context, string));
        switch (n) {
            case 0: {
                this.AFAdRevenueData.put("response", "OK");
                try {
                    AFLogger.INSTANCE.d(AFg1cSDK.copydefault, "InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            this.getCurrencyIso4217Code.put("val", object);
                            this.AFAdRevenueData.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        this.getCurrencyIso4217Code.put("clk", Long.toString(l));
                        this.AFAdRevenueData.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        this.getCurrencyIso4217Code.put("install", Long.toString(l2));
                        this.AFAdRevenueData.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            this.getCurrencyIso4217Code.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.INSTANCE.e(AFg1cSDK.copydefault, "some method not exist", noSuchMethodError, false, false);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            this.AFAdRevenueData.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    AFLogger.INSTANCE.w(AFg1cSDK.copydefault, "ReferrerClient: InstallReferrer is not ready");
                    this.getCurrencyIso4217Code.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    AFLogger.INSTANCE.w(AFg1cSDK.copydefault, "Failed to get install referrer: " + throwable.getMessage());
                    this.getCurrencyIso4217Code.put("err", throwable.getMessage());
                    AFLogger.INSTANCE.e(AFg1cSDK.copydefault, "Failed to get install referrer", throwable, false, false);
                }
                break;
            }
            case 2: {
                AFLogger.INSTANCE.w(AFg1cSDK.copydefault, "InstallReferrer FEATURE_NOT_SUPPORTED");
                this.AFAdRevenueData.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                this.AFAdRevenueData.put("response", "SERVICE_UNAVAILABLE");
                AFLogger.INSTANCE.w(AFg1cSDK.copydefault, "InstallReferrer not supported");
                break;
            }
            case 3: {
                AFLogger.INSTANCE.w(AFg1cSDK.copydefault, "InstallReferrer DEVELOPER_ERROR");
                this.AFAdRevenueData.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                AFLogger.INSTANCE.w(AFg1cSDK.copydefault, "InstallReferrer SERVICE_DISCONNECTED");
                this.AFAdRevenueData.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                AFLogger.INSTANCE.w(AFg1cSDK.copydefault, "responseCode not found.");
            }
        }
        AFLogger.INSTANCE.d(AFg1cSDK.copydefault, "Install Referrer collected locally");
        this.getMediationNetwork();
    }
}

