/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1qSDK;
import com.appsflyer.internal.AFd1nSDK;
import com.appsflyer.internal.AFh1sSDK;
import com.appsflyer.internal.AFj1mSDK;
import com.appsflyer.internal.AFj1wSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFj1vSDK
extends AFj1wSDK {
    public final Map<String, Object> getRevenue = new HashMap<String, Object>();
    @NonNull
    final ExecutorService AFAdRevenueData;

    public AFj1vSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService, @NonNull AFd1nSDK aFd1nSDK) {
        super("store", "google", aFd1nSDK, runnable);
        this.AFAdRevenueData = executorService;
    }

    private boolean getRevenue(@NonNull Context context) {
        if (!this.getMonetizationNetwork()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFb1qSDK.getMonetizationNetwork(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.INSTANCE.d(AFh1sSDK.copy, "Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            AFLogger.INSTANCE.v(AFh1sSDK.copy, "Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFh1sSDK.copy, "An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.INSTANCE.d(AFh1sSDK.copy, "Install referrer is not allowed");
        return false;
    }

    @Override
    public final void getMonetizationNetwork(Context context) {
        if (!this.getRevenue(context)) {
            return;
        }
        AFj1vSDK aFj1vSDK = this;
        this.component2 = System.currentTimeMillis();
        aFj1vSDK.component1 = AFj1mSDK.AFa1zSDK.AFAdRevenueData;
        aFj1vSDK.addObserver(new Observer(aFj1vSDK){
            private /* synthetic */ AFj1mSDK AFAdRevenueData;
            {
                this.AFAdRevenueData = aFj1mSDK;
            }

            public final void update(Observable o, Object arg) {
                this.AFAdRevenueData.getMonetizationNetwork.run();
            }
        });
        try {
            aFj1vSDK = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.INSTANCE.d(AFh1sSDK.copy, "Connecting to Install Referrer Library...");
            aFj1vSDK.startConnection(new InstallReferrerStateListener(){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int responseCode) {
                    AFj1vSDK.this.AFAdRevenueData.execute(() -> AFj1vSDK.this.getCurrencyIso4217Code(this.val$referrerClient, this.val$context, responseCode));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.INSTANCE.d(AFh1sSDK.copy, "Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFh1sSDK.copy, "referrerClient -> startConnection", throwable);
            return;
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final void getCurrencyIso4217Code(InstallReferrerClient installReferrerClient, Context context, int n) {
        this.getRevenue.put("code", String.valueOf(n));
        String string = "com.android.vending";
        this.getCurrencyIso4217Code.put("api_ver", AFb1qSDK.AFAdRevenueData(context, string));
        this.getCurrencyIso4217Code.put("api_ver_name", AFb1qSDK.getRevenue(context, string));
        switch (n) {
            case 0: {
                this.getCurrencyIso4217Code.put("response", "OK");
                try {
                    AFLogger.INSTANCE.d(AFh1sSDK.copy, "InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            this.getRevenue.put("val", object);
                            this.getCurrencyIso4217Code.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        this.getRevenue.put("clk", Long.toString(l));
                        this.getCurrencyIso4217Code.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        this.getRevenue.put("install", Long.toString(l2));
                        this.getCurrencyIso4217Code.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            this.getRevenue.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.INSTANCE.e(AFh1sSDK.copy, "some method not exist", noSuchMethodError, false, false);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            this.getCurrencyIso4217Code.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    AFLogger.INSTANCE.w(AFh1sSDK.copy, "ReferrerClient: InstallReferrer is not ready");
                    this.getRevenue.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    AFLogger.INSTANCE.w(AFh1sSDK.copy, "Failed to get install referrer: " + throwable.getMessage());
                    this.getRevenue.put("err", throwable.getMessage());
                    AFLogger.INSTANCE.e(AFh1sSDK.copy, "Failed to get install referrer", throwable, false, false);
                }
                break;
            }
            case 2: {
                AFLogger.INSTANCE.w(AFh1sSDK.copy, "InstallReferrer FEATURE_NOT_SUPPORTED");
                this.getCurrencyIso4217Code.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                this.getCurrencyIso4217Code.put("response", "SERVICE_UNAVAILABLE");
                AFLogger.INSTANCE.w(AFh1sSDK.copy, "InstallReferrer not supported");
                break;
            }
            case 3: {
                AFLogger.INSTANCE.w(AFh1sSDK.copy, "InstallReferrer DEVELOPER_ERROR");
                this.getCurrencyIso4217Code.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                AFLogger.INSTANCE.w(AFh1sSDK.copy, "InstallReferrer SERVICE_DISCONNECTED");
                this.getCurrencyIso4217Code.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                AFLogger.INSTANCE.w(AFh1sSDK.copy, "responseCode not found.");
            }
        }
        AFLogger.INSTANCE.d(AFh1sSDK.copy, "Install Referrer collected locally");
        this.getRevenue();
    }
}

