/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFh1aSDK;
import com.appsflyer.internal.AFh1dSDK;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFi1ySDK {
    private final boolean getMediationNetwork;
    @NonNull
    public final String getCurrencyIso4217Code;
    @NonNull
    public final String getMonetizationNetwork;
    @NonNull
    public final AFh1aSDK AFAdRevenueData;
    @Nullable
    public final AFh1dSDK getRevenue;

    public AFi1ySDK(@NonNull String object) throws JSONException {
        if (object == null) {
            throw new JSONException("Failed to parse remote configuration JSON: originalJson is null");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            this.getCurrencyIso4217Code = jSONObject.getString("ver");
            this.getMediationNetwork = jSONObject.optBoolean("test_mode");
            this.getMonetizationNetwork = object;
            this.AFAdRevenueData = this.getCurrencyIso4217Code.startsWith("default") ? AFh1aSDK.getMediationNetwork : AFh1aSDK.getRevenue;
            object = null;
            jSONObject = jSONObject.optJSONObject("features");
            if (jSONObject != null) {
                object = new AFh1dSDK(jSONObject);
            }
            this.getRevenue = object;
            return;
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("Error in RC config parsing", jSONException);
            throw new JSONException("Failed to parse remote configuration JSON");
        }
    }

    public final boolean equals(Object o) {
        AFi1ySDK aFi1ySDK;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        aFi1ySDK = aFi1ySDK;
        if (this.getMediationNetwork != aFi1ySDK.getMediationNetwork) {
            return false;
        }
        if (!this.getCurrencyIso4217Code.equals(aFi1ySDK.getCurrencyIso4217Code)) {
            return false;
        }
        return this.getMonetizationNetwork.equals(aFi1ySDK.getMonetizationNetwork);
    }

    public final int hashCode() {
        int n = this.getMediationNetwork ? 1 : 0;
        n = n * 31 + this.getCurrencyIso4217Code.hashCode();
        n = n * 31 + this.getMonetizationNetwork.hashCode();
        if (this.getRevenue != null) {
            n = n * 31 + ((Object)this.getRevenue).hashCode();
        }
        return n;
    }
}

