/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1uSDK;
import com.appsflyer.internal.AFd1sSDK;
import com.appsflyer.internal.AFg1gSDK;
import com.appsflyer.internal.AFi1jSDK;
import com.appsflyer.internal.AFi1rSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFi1sSDK
extends AFi1rSDK {
    public final Map<String, Object> values = new HashMap<String, Object>();
    @NonNull
    private final ExecutorService AFInAppEventType;

    public AFi1sSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService, @NonNull AFd1sSDK aFd1sSDK) {
        super("store", "google", aFd1sSDK, runnable);
        this.AFInAppEventType = executorService;
    }

    private boolean AFInAppEventType(@NonNull Context context) {
        if (!this.AFInAppEventType()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFb1uSDK.AFInAppEventParameterName(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.INSTANCE.d(AFg1gSDK.d, "Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            AFLogger.INSTANCE.v(AFg1gSDK.d, "Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFg1gSDK.d, "An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.INSTANCE.d(AFg1gSDK.d, "Install referrer is not allowed");
        return false;
    }

    @Override
    public final void valueOf(Context context) {
        if (!this.AFInAppEventType(context)) {
            return;
        }
        AFi1sSDK aFi1sSDK = this;
        this.registerClient = System.currentTimeMillis();
        aFi1sSDK.d = AFi1jSDK.AFa1tSDK.AFKeystoreWrapper;
        aFi1sSDK.addObserver(new Observer(aFi1sSDK){
            private /* synthetic */ AFi1jSDK valueOf;
            {
                this.valueOf = aFi1jSDK;
            }

            public final void update(Observable observable, Object object) {
                this.valueOf.AFInAppEventParameterName.run();
            }
        });
        try {
            aFi1sSDK = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.INSTANCE.d(AFg1gSDK.d, "Connecting to Install Referrer Library...");
            aFi1sSDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFi1sSDK, context){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int n) {
                    AFi1sSDK.this.AFInAppEventType.execute(() -> AFi1sSDK.this.AFKeystoreWrapper(this.val$referrerClient, this.val$context, n));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.INSTANCE.d(AFg1gSDK.d, "Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFg1gSDK.d, "referrerClient -> startConnection", throwable);
            return;
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final void AFKeystoreWrapper(InstallReferrerClient installReferrerClient, Context context, int n) {
        this.values.put("code", String.valueOf(n));
        String string = "com.android.vending";
        this.valueOf.put("api_ver", AFb1uSDK.values(context, string));
        this.valueOf.put("api_ver_name", AFb1uSDK.AFKeystoreWrapper(context, string));
        switch (n) {
            case 0: {
                this.valueOf.put("response", "OK");
                try {
                    AFLogger.INSTANCE.d(AFg1gSDK.d, "InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            this.values.put("val", object);
                            this.valueOf.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        this.values.put("clk", Long.toString(l));
                        this.valueOf.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        this.values.put("install", Long.toString(l2));
                        this.valueOf.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            this.values.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.INSTANCE.e(AFg1gSDK.d, "some method not exist", noSuchMethodError, false, false);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            this.valueOf.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    AFLogger.INSTANCE.w(AFg1gSDK.d, "ReferrerClient: InstallReferrer is not ready");
                    this.values.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    AFLogger.INSTANCE.w(AFg1gSDK.d, "Failed to get install referrer: " + throwable.getMessage());
                    this.values.put("err", throwable.getMessage());
                    AFLogger.INSTANCE.e(AFg1gSDK.d, "Failed to get install referrer", throwable, false, false);
                }
                break;
            }
            case 2: {
                AFLogger.INSTANCE.w(AFg1gSDK.d, "InstallReferrer FEATURE_NOT_SUPPORTED");
                this.valueOf.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                this.valueOf.put("response", "SERVICE_UNAVAILABLE");
                AFLogger.INSTANCE.w(AFg1gSDK.d, "InstallReferrer not supported");
                break;
            }
            case 3: {
                AFLogger.INSTANCE.w(AFg1gSDK.d, "InstallReferrer DEVELOPER_ERROR");
                this.valueOf.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                AFLogger.INSTANCE.w(AFg1gSDK.d, "InstallReferrer SERVICE_DISCONNECTED");
                this.valueOf.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                AFLogger.INSTANCE.w(AFg1gSDK.d, "responseCode not found.");
            }
        }
        AFLogger.INSTANCE.d(AFg1gSDK.d, "Install Referrer collected locally");
        this.AFKeystoreWrapper();
    }
}

