/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.ContentProviderClient;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.DeadObjectException;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1uSDK;
import com.appsflyer.internal.AFd1mSDK;
import com.appsflyer.internal.AFg1gSDK;
import com.appsflyer.internal.AFi1jSDK;
import java.util.Observable;
import java.util.Observer;

public final class AFi1lSDK
extends AFi1jSDK {
    final ProviderInfo AFInAppEventType;
    private final AFd1mSDK values;

    public AFi1lSDK(ProviderInfo providerInfo, Runnable runnable, AFd1mSDK aFd1mSDK) {
        super("af_referrer", providerInfo.authority, runnable);
        this.values = aFd1mSDK;
        this.AFInAppEventType = providerInfo;
    }

    @Override
    public final void valueOf(Context object) {
        object = new Runnable(this, (Context)object){
            private /* synthetic */ Context AFInAppEventType;
            private /* synthetic */ AFi1lSDK AFInAppEventParameterName;
            {
                this.AFInAppEventParameterName = aFi1lSDK;
                this.AFInAppEventType = context;
            }

            @Override
            public final void run() {
                AFi1lSDK aFi1lSDK = this.AFInAppEventParameterName;
                this.AFInAppEventParameterName.registerClient = System.currentTimeMillis();
                aFi1lSDK.d = AFi1jSDK.AFa1tSDK.AFKeystoreWrapper;
                aFi1lSDK.addObserver(new Observer(aFi1lSDK){
                    private /* synthetic */ AFi1jSDK valueOf;
                    {
                        this.valueOf = aFi1jSDK;
                    }

                    public final void update(Observable observable, Object object) {
                        this.valueOf.AFInAppEventParameterName.run();
                    }
                });
                aFi1lSDK = Uri.parse((String)("content://" + this.AFInAppEventParameterName.AFInAppEventType.authority + "/transaction_id"));
                ContentProviderClient contentProviderClient = AFi1lSDK.values(this.AFInAppEventType, (Uri)aFi1lSDK);
                Cursor cursor = null;
                if (contentProviderClient != null) {
                    try {
                        cursor = contentProviderClient.query((Uri)aFi1lSDK, null, "app_id=" + this.AFInAppEventType.getPackageName(), null, null);
                    }
                    catch (DeadObjectException deadObjectException) {
                        AFLogger.INSTANCE.e(AFg1gSDK.afRDLog, "Failed to acquire unstable content providerClient", deadObjectException, false);
                    }
                    catch (RemoteException remoteException) {
                        AFLogger.INSTANCE.e(AFg1gSDK.afRDLog, "Failed to query unstable content providerClient", remoteException, false);
                    }
                    catch (Throwable throwable) {
                        AFLogger.INSTANCE.e(AFg1gSDK.afRDLog, "Error to get data from providerClient ", throwable, false);
                    }
                    finally {
                        if (Build.VERSION.SDK_INT >= 24) {
                            contentProviderClient.close();
                        } else {
                            contentProviderClient.release();
                        }
                    }
                }
                if (cursor != null) {
                    int n = cursor.getColumnIndex("transaction_id");
                    if (n == -1) {
                        AFLogger.INSTANCE.w(AFg1gSDK.afRDLog, "Wrong column name");
                        this.AFInAppEventParameterName.valueOf.put("response", "FEATURE_NOT_SUPPORTED");
                    } else {
                        this.AFInAppEventParameterName.valueOf.put("response", "OK");
                        if (cursor.moveToFirst()) {
                            String string = cursor.getString(n);
                            cursor.close();
                            if (string != null && !string.isEmpty()) {
                                this.AFInAppEventParameterName.valueOf.put("referrer", string);
                            }
                        }
                    }
                    cursor.close();
                } else {
                    AFLogger.INSTANCE.w(AFg1gSDK.afRDLog, "ContentProvider query failed, got null Cursor");
                    this.AFInAppEventParameterName.valueOf.put("response", "SERVICE_UNAVAILABLE");
                }
                this.AFInAppEventParameterName.valueOf.put("api_ver", AFb1uSDK.values(this.AFInAppEventType, this.AFInAppEventParameterName.AFInAppEventType.packageName));
                this.AFInAppEventParameterName.valueOf.put("api_ver_name", AFb1uSDK.AFKeystoreWrapper(this.AFInAppEventType, this.AFInAppEventParameterName.AFInAppEventType.packageName));
                this.AFInAppEventParameterName.AFKeystoreWrapper();
            }
        };
        this.values.AFInAppEventParameterName().execute((Runnable)object);
    }

    @VisibleForTesting
    @Nullable
    public static ContentProviderClient values(Context context, Uri uri) {
        ContentProviderClient contentProviderClient = null;
        try {
            contentProviderClient = context.getContentResolver().acquireUnstableContentProviderClient(uri);
        }
        catch (SecurityException securityException) {
            AFLogger.INSTANCE.e(AFg1gSDK.afRDLog, "Failed to acquire unstable content providerClient due to SecurityException", securityException, false);
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFg1gSDK.afRDLog, "Failed to acquire unstable content providerClient due to unexpected throwable", throwable, false);
        }
        return contentProviderClient;
    }
}

