/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1qSDK;
import com.appsflyer.internal.AFd1rSDK;
import com.appsflyer.internal.AFg1hSDK;
import com.appsflyer.internal.AFi1nSDK;
import com.appsflyer.internal.AFi1ySDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFi1pSDK
extends AFi1ySDK {
    public final Map<String, Object> valueOf = new HashMap<String, Object>();
    @NonNull
    private final ExecutorService AFKeystoreWrapper;

    public AFi1pSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService, @NonNull AFd1rSDK aFd1rSDK) {
        super("store", "google", aFd1rSDK, runnable);
        this.AFKeystoreWrapper = executorService;
    }

    private boolean AFInAppEventType(@NonNull Context context) {
        if (!this.AFInAppEventParameterName()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFb1qSDK.AFInAppEventType(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                com.appsflyer.AFLogger.INSTANCE.d(AFg1hSDK.e, "Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            com.appsflyer.AFLogger.INSTANCE.v(AFg1hSDK.e, "Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.INSTANCE.e(AFg1hSDK.e, "An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        com.appsflyer.AFLogger.INSTANCE.d(AFg1hSDK.e, "Install referrer is not allowed");
        return false;
    }

    @Override
    public final void values(Context context) {
        if (!this.AFInAppEventType(context)) {
            return;
        }
        AFi1pSDK aFi1pSDK = this;
        this.d = System.currentTimeMillis();
        aFi1pSDK.unregisterClient = AFi1nSDK.AFa1uSDK.AFKeystoreWrapper;
        aFi1pSDK.addObserver(new Observer(aFi1pSDK){
            private /* synthetic */ AFi1nSDK values;
            {
                this.values = aFi1nSDK;
            }

            public final void update(Observable observable, Object object) {
                this.values.AFInAppEventType.run();
            }
        });
        try {
            aFi1pSDK = InstallReferrerClient.newBuilder((Context)context).build();
            com.appsflyer.AFLogger.INSTANCE.d(AFg1hSDK.e, "Connecting to Install Referrer Library...");
            aFi1pSDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFi1pSDK, context){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int n) {
                    AFi1pSDK.this.AFKeystoreWrapper.execute(() -> AFi1pSDK.this.AFInAppEventType(this.val$referrerClient, this.val$context, n));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    com.appsflyer.AFLogger.INSTANCE.d(AFg1hSDK.e, "Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.INSTANCE.e(AFg1hSDK.e, "referrerClient -> startConnection", throwable);
            return;
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final void AFInAppEventType(InstallReferrerClient installReferrerClient, Context context, int n) {
        this.valueOf.put("code", String.valueOf(n));
        String string = "com.android.vending";
        this.values.put("api_ver", AFb1qSDK.AFInAppEventParameterName(context, string));
        this.values.put("api_ver_name", AFb1qSDK.AFKeystoreWrapper(context, string));
        switch (n) {
            case 0: {
                this.values.put("response", "OK");
                try {
                    com.appsflyer.AFLogger.INSTANCE.d(AFg1hSDK.e, "InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            this.valueOf.put("val", object);
                            this.values.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        this.valueOf.put("clk", Long.toString(l));
                        this.values.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        this.valueOf.put("install", Long.toString(l2));
                        this.values.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            this.valueOf.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.INSTANCE.e(AFg1hSDK.e, "some method not exist", noSuchMethodError, false, false);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            this.values.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    com.appsflyer.AFLogger.INSTANCE.w(AFg1hSDK.e, "ReferrerClient: InstallReferrer is not ready");
                    this.valueOf.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    com.appsflyer.AFLogger.INSTANCE.w(AFg1hSDK.e, "Failed to get install referrer: " + throwable.getMessage());
                    this.valueOf.put("err", throwable.getMessage());
                    com.appsflyer.AFLogger.INSTANCE.e(AFg1hSDK.e, "Failed to get install referrer", throwable, false, false);
                }
                break;
            }
            case 2: {
                com.appsflyer.AFLogger.INSTANCE.w(AFg1hSDK.e, "InstallReferrer FEATURE_NOT_SUPPORTED");
                this.values.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                this.values.put("response", "SERVICE_UNAVAILABLE");
                com.appsflyer.AFLogger.INSTANCE.w(AFg1hSDK.e, "InstallReferrer not supported");
                break;
            }
            case 3: {
                com.appsflyer.AFLogger.INSTANCE.w(AFg1hSDK.e, "InstallReferrer DEVELOPER_ERROR");
                this.values.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                com.appsflyer.AFLogger.INSTANCE.w(AFg1hSDK.e, "InstallReferrer SERVICE_DISCONNECTED");
                this.values.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                com.appsflyer.AFLogger.INSTANCE.w(AFg1hSDK.e, "responseCode not found.");
            }
        }
        com.appsflyer.AFLogger.INSTANCE.d(AFg1hSDK.e, "Install Referrer collected locally");
        this.AFInAppEventType();
    }
}

