/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1eSDK;
import com.appsflyer.internal.AFg1mSDK;
import com.appsflyer.internal.AFg1vSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFg1sSDK
extends AFg1vSDK {
    public final Map<String, Object> values = new HashMap<String, Object>();
    @NonNull
    private final ExecutorService AFKeystoreWrapper;

    public AFg1sSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService) {
        super("store", "google", runnable);
        this.AFKeystoreWrapper = executorService;
    }

    private static boolean AFInAppEventType(@NonNull Context context) {
        if (!AFg1sSDK.values()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFa1eSDK.values(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                com.appsflyer.AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            com.appsflyer.AFLogger.afRDLog("Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        com.appsflyer.AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    @Override
    public final void AFInAppEventParameterName(Context context) {
        if (!AFg1sSDK.AFInAppEventType(context)) {
            return;
        }
        AFg1sSDK aFg1sSDK = this;
        this.afErrorLog = System.currentTimeMillis();
        aFg1sSDK.afDebugLog = AFg1mSDK.AFa1vSDK.AFKeystoreWrapper;
        aFg1sSDK.addObserver(new Observer(aFg1sSDK){
            private /* synthetic */ AFg1mSDK AFInAppEventParameterName;
            {
                this.AFInAppEventParameterName = aFg1mSDK;
            }

            public final void update(Observable observable, Object object) {
                this.AFInAppEventParameterName.AFInAppEventType.run();
            }
        });
        try {
            aFg1sSDK = InstallReferrerClient.newBuilder((Context)context).build();
            com.appsflyer.AFLogger.afDebugLog("Connecting to Install Referrer Library...");
            aFg1sSDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFg1sSDK, context){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int n) {
                    AFg1sSDK.this.AFKeystoreWrapper.execute(() -> AFg1sSDK.AFInAppEventParameterName(AFg1sSDK.this, this.val$referrerClient, this.val$context, n));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    com.appsflyer.AFLogger.afDebugLog("Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("referrerClient -> startConnection", throwable);
            return;
        }
    }

    static /* synthetic */ void AFInAppEventParameterName(AFg1sSDK aFg1sSDK, InstallReferrerClient installReferrerClient, Context context, int n) {
        aFg1sSDK.values.put("code", String.valueOf(n));
        String string = "com.android.vending";
        aFg1sSDK.valueOf.put("api_ver", AFa1eSDK.AFInAppEventParameterName(context, string));
        aFg1sSDK.valueOf.put("api_ver_name", AFa1eSDK.AFKeystoreWrapper(context, string));
        switch (n) {
            case 0: {
                aFg1sSDK.valueOf.put("response", "OK");
                try {
                    com.appsflyer.AFLogger.afDebugLog("InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            aFg1sSDK.values.put("val", object);
                            aFg1sSDK.valueOf.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        aFg1sSDK.values.put("clk", Long.toString(l));
                        aFg1sSDK.valueOf.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        aFg1sSDK.values.put("install", Long.toString(l2));
                        aFg1sSDK.valueOf.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            aFg1sSDK.values.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("some method not exist", noSuchMethodError);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            aFg1sSDK.valueOf.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    com.appsflyer.AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                    aFg1sSDK.values.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    com.appsflyer.AFLogger.afWarnLog("Failed to get install referrer: " + throwable.getMessage());
                    aFg1sSDK.values.put("err", throwable.getMessage());
                    com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("Failed to get install referrer", throwable);
                }
                break;
            }
            case 2: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer FEATURE_NOT_SUPPORTED");
                aFg1sSDK.valueOf.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                aFg1sSDK.valueOf.put("response", "SERVICE_UNAVAILABLE");
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer not supported");
                break;
            }
            case 3: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer DEVELOPER_ERROR");
                aFg1sSDK.valueOf.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer SERVICE_DISCONNECTED");
                aFg1sSDK.valueOf.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                com.appsflyer.AFLogger.afWarnLog("responseCode not found.");
            }
        }
        com.appsflyer.AFLogger.afDebugLog("Install Referrer collected locally");
        aFg1sSDK.AFInAppEventType();
    }
}

