/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1fSDK;
import com.appsflyer.internal.AFf1pSDK;
import com.appsflyer.internal.AFf1uSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFf1qSDK
extends AFf1uSDK {
    public final Map<String, Object> valueOf = new HashMap<String, Object>();
    @NonNull
    private final ExecutorService AFInAppEventType;

    public AFf1qSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService) {
        super("store", "google", runnable);
        this.AFInAppEventType = executorService;
    }

    private static boolean AFInAppEventType(@NonNull Context context) {
        if (!AFf1qSDK.valueOf()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFa1fSDK.values(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            AFLogger.afRDLog("Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    @Override
    public final void valueOf(Context context) {
        if (!AFf1qSDK.AFInAppEventType(context)) {
            return;
        }
        AFf1qSDK aFf1qSDK = this;
        this.afInfoLog = System.currentTimeMillis();
        aFf1qSDK.afDebugLog = AFf1pSDK.AFa1zSDK.AFInAppEventType;
        aFf1qSDK.addObserver(new Observer(aFf1qSDK){
            private /* synthetic */ AFf1pSDK values;
            {
                this.values = aFf1pSDK;
            }

            public final void update(Observable observable, Object object) {
                this.values.values.run();
            }
        });
        try {
            aFf1qSDK = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.afDebugLog("Connecting to Install Referrer Library...");
            aFf1qSDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFf1qSDK, context){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int n) {
                    AFf1qSDK.this.AFInAppEventType.execute(() -> AFf1qSDK.valueOf(AFf1qSDK.this, this.val$referrerClient, this.val$context, n));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.afDebugLog("Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("referrerClient -> startConnection", throwable);
            return;
        }
    }

    static /* synthetic */ void valueOf(AFf1qSDK aFf1qSDK, InstallReferrerClient installReferrerClient, Context context, int n) {
        aFf1qSDK.valueOf.put("code", String.valueOf(n));
        String string = "com.android.vending";
        aFf1qSDK.AFInAppEventParameterName.put("api_ver", AFa1fSDK.AFInAppEventType(context, string));
        aFf1qSDK.AFInAppEventParameterName.put("api_ver_name", AFa1fSDK.AFKeystoreWrapper(context, string));
        switch (n) {
            case 0: {
                aFf1qSDK.AFInAppEventParameterName.put("response", "OK");
                try {
                    AFLogger.afDebugLog("InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            aFf1qSDK.valueOf.put("val", object);
                            aFf1qSDK.AFInAppEventParameterName.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        aFf1qSDK.valueOf.put("clk", Long.toString(l));
                        aFf1qSDK.AFInAppEventParameterName.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        aFf1qSDK.valueOf.put("install", Long.toString(l2));
                        aFf1qSDK.AFInAppEventParameterName.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            aFf1qSDK.valueOf.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.afErrorLogForExcManagerOnly("some method not exist", noSuchMethodError);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            aFf1qSDK.AFInAppEventParameterName.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                    aFf1qSDK.valueOf.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    AFLogger.afWarnLog("Failed to get install referrer: " + throwable.getMessage());
                    aFf1qSDK.valueOf.put("err", throwable.getMessage());
                    AFLogger.afErrorLogForExcManagerOnly("Failed to get install referrer", throwable);
                }
                break;
            }
            case 2: {
                AFLogger.afWarnLog("InstallReferrer FEATURE_NOT_SUPPORTED");
                aFf1qSDK.AFInAppEventParameterName.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                aFf1qSDK.AFInAppEventParameterName.put("response", "SERVICE_UNAVAILABLE");
                AFLogger.afWarnLog("InstallReferrer not supported");
                break;
            }
            case 3: {
                AFLogger.afWarnLog("InstallReferrer DEVELOPER_ERROR");
                aFf1qSDK.AFInAppEventParameterName.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                AFLogger.afWarnLog("InstallReferrer SERVICE_DISCONNECTED");
                aFf1qSDK.AFInAppEventParameterName.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                AFLogger.afWarnLog("responseCode not found.");
            }
        }
        AFLogger.afDebugLog("Install Referrer collected locally");
        aFf1qSDK.values();
    }
}

