/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1dSDK;
import com.appsflyer.internal.AFc1bSDK;
import com.appsflyer.internal.AFd1tSDK;
import com.appsflyer.internal.AFd1wSDK;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class AFd1iSDK
extends AFd1wSDK<Map<String, Object>> {
    private static final int afErrorLog = (int)TimeUnit.SECONDS.toMillis(2L);
    private Map<String, Object> afInfoLog;
    private final Context AFLogger;
    private final Map<String, Object> afRDLog;
    private final Uri afDebugLog;
    private final List<String> afErrorLogForExcManagerOnly;

    public AFd1iSDK(@NonNull Context context, @NonNull Map<String, Object> map, @NonNull Uri uri, @NonNull List<String> list) {
        super(AFd1tSDK.afRDLog, new AFd1tSDK[]{AFd1tSDK.valueOf}, "ResolveEsp");
        this.AFLogger = context;
        this.afRDLog = map;
        this.afDebugLog = uri;
        this.afErrorLogForExcManagerOnly = list;
    }

    @Override
    public final long AFInAppEventType() {
        return 60000L;
    }

    @Override
    public final boolean AFInAppEventParameterName() {
        return false;
    }

    @Override
    @NonNull
    public final AFc1bSDK valueOf() throws Exception {
        AFd1iSDK aFd1iSDK = this;
        if (!aFd1iSDK.AFKeystoreWrapper(aFd1iSDK.afDebugLog.toString())) {
            AFa1dSDK.AFInAppEventType().AFKeystoreWrapper(this.AFLogger, this.afRDLog, this.afDebugLog);
            return AFc1bSDK.AFInAppEventType;
        }
        long l = System.currentTimeMillis();
        String string = this.afDebugLog.toString();
        Integer n = null;
        Map<String, Object> map = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            map = AFd1iSDK.AFInAppEventParameterName(Uri.parse((String)string));
            string = (String)map.get("res");
            n = (Integer)map.get("status");
            map = (String)map.get("error");
            if (string == null || !this.AFKeystoreWrapper(string)) break;
            if (i >= 4) continue;
            ((AbstractCollection)arrayList).add(string);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("res", string != null ? string : "");
        hashMap.put("status", n != null ? n : -1);
        if (map != null) {
            hashMap.put("error", map);
        }
        if (!((AbstractCollection)arrayList).isEmpty()) {
            hashMap.put("redirects", arrayList);
        }
        hashMap.put("latency", System.currentTimeMillis() - l);
        map = this.afRDLog;
        synchronized (map) {
            this.afRDLog.put("af_deeplink_r", hashMap);
            this.afRDLog.put("af_deeplink", this.afDebugLog.toString());
        }
        AFa1dSDK.AFInAppEventType().AFKeystoreWrapper(this.AFLogger, this.afRDLog, string != null ? Uri.parse((String)string) : this.afDebugLog);
        this.afInfoLog = hashMap;
        return AFc1bSDK.AFInAppEventType;
    }

    private static Map<String, Object> AFInAppEventParameterName(Uri object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            com.appsflyer.AFLogger.afDebugLog("ESP deeplink resolving is started: " + object.toString());
            object = (HttpURLConnection)new URL(object.toString()).openConnection();
            ((HttpURLConnection)object).setInstanceFollowRedirects(false);
            ((URLConnection)object).setReadTimeout(afErrorLog);
            ((URLConnection)object).setConnectTimeout(afErrorLog);
            ((URLConnection)object).setRequestProperty("User-agent", "Dalvik/2.1.0 (Linux; U; Android 6.0.1; Nexus 5 Build/M4B30Z)");
            ((URLConnection)object).setRequestProperty("af-esp", "6.11.2");
            int n = ((HttpURLConnection)object).getResponseCode();
            ((AbstractMap)hashMap).put("status", n);
            if (300 <= n && n <= 305) {
                ((AbstractMap)hashMap).put("res", ((URLConnection)object).getHeaderField("Location"));
            }
            ((HttpURLConnection)object).disconnect();
            com.appsflyer.AFLogger.afDebugLog("ESP deeplink resolving is finished");
        }
        catch (Throwable throwable) {
            ((AbstractMap)hashMap).put("error", throwable.getLocalizedMessage());
            com.appsflyer.AFLogger.afErrorLog(throwable.getMessage(), throwable);
        }
        return hashMap;
    }

    private boolean AFKeystoreWrapper(String string) {
        if (string.contains("af_tranid=")) {
            return false;
        }
        com.appsflyer.AFLogger.afRDLog("Validate if link " + string + " belongs to ESP domains: " + this.afErrorLogForExcManagerOnly);
        try {
            return this.afErrorLogForExcManagerOnly.contains(new URL(string).getHost());
        }
        catch (MalformedURLException malformedURLException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("MalformedURLException ESP link", malformedURLException);
            return false;
        }
    }
}

